/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.extension.jogl;

import java.awt.Canvas;
import java.awt.Component;
import java.nio.Buffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import net.dzzd.access.ICamera3D;
import net.dzzd.access.IFace3D;
import net.dzzd.access.ILight3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IMesh3DOctree;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene3D;
import net.dzzd.access.ITexture;
import net.dzzd.access.IVertex3D;
import net.dzzd.core.DirectInput;
import net.dzzd.core.Light3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Mesh3DOctree;
import net.dzzd.core.Point3D;
import net.dzzd.core.Render2D;
import net.dzzd.core.Render3D;
import net.dzzd.core.Texture;
import net.dzzd.utils.Log;

public final class Render3DJOGL
extends Render3D {
    private GLContext context;
    private GLCanvas canvas;
    private GL gl;
    private GLU glu;
    private IScene3D scene;
    private Point3D rotation;
    private float[] light0Pos;
    private float[] light0Val;
    private float[] matAmbient;
    private float[] matDiffuse;
    private float[] matSpecular;
    private CompiledMesh3D[] compiledMeshes;
    private CompiledMaterial[] compiledMaterials;
    private CompiledTexture[] compiledTextures;
    ITexture currentTexture = null;
    IMaterial currentMaterial = null;
    boolean textureEnabled = false;
    boolean lightEnabled = false;
    boolean glTriangleOn = false;

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Render3DJOGL() throws Throwable {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.setAutoSwapBufferMode(false);
        this.glu = new GLU();
        this.context = this.canvas.getContext();
        this.gl = this.context.getGL();
        ((Render2D)this).directInput = new DirectInput((Component)this.canvas);
        this.rotation = new Point3D();
        this.light0Pos = new float[4];
        this.light0Val = new float[4];
        this.matAmbient = new float[4];
        this.matDiffuse = new float[4];
        this.matSpecular = new float[4];
        this.initCompiledBuffers();
    }

    private void initCompiledBuffers() {
        this.compiledMeshes = new CompiledMesh3D[65536];
        this.compiledMaterials = new CompiledMaterial[1024];
        this.compiledTextures = new CompiledTexture[1024];
    }

    public void setSize(int n, int n2, int n3) {
        super.setSize(n, n2, n3);
        this.canvas.setSize(n, n2);
    }

    public void renderScene3D(IScene3D iScene3D) {
        if (iScene3D == null) {
            return;
        }
        this.scene = iScene3D;
        this.makeContentCurrent();
        super.renderScene3D(iScene3D);
    }

    protected void startFrame(IScene3D iScene3D) {
        this.initRender3DJOGL();
        this.setCamera3D();
    }

    protected void renderFrame(IScene3D iScene3D) {
        super.renderFrame(iScene3D);
    }

    protected void endFrame(IScene3D iScene3D) {
        this.context.release();
        if (((Render2D)this).isScreenUpdateEnabled) {
            this.canvas.swapBuffers();
        }
    }

    protected void setCurrentMesh3D(Mesh3D mesh3D) {
        super.setCurrentMesh3D(mesh3D);
        this.cMesh3D.getAxis3D().getRotationXZY((IPoint3D)this.rotation);
        float f = (float)(this.rotation.getX() * 180.0 / Math.PI);
        float f2 = (float)(this.rotation.getY() * 180.0 / Math.PI);
        float f3 = (float)(this.rotation.getZ() * 180.0 / Math.PI);
        IPoint3D iPoint3D = this.cMesh3D.getAxis3D().getOrigin();
        float f4 = (float)iPoint3D.getX();
        float f5 = (float)iPoint3D.getY();
        float f6 = (float)iPoint3D.getZ();
        IPoint3D iPoint3D2 = this.cMesh3D.getPivot();
        float f7 = (float)iPoint3D2.getX();
        float f8 = (float)iPoint3D2.getY();
        float f9 = (float)iPoint3D2.getZ();
        this.gl.glLoadIdentity();
        this.gl.glScalef(1.0f, 1.0f, -1.0f);
        this.gl.glTranslatef(0.0f, 0.0f, 0.0f);
        this.gl.glTranslatef(f4, f5, f6);
        this.gl.glRotatef(-f2, 0.0f, 1.0f, 0.0f);
        this.gl.glRotatef(-f3, 0.0f, 0.0f, 1.0f);
        this.gl.glRotatef(-f, 1.0f, 0.0f, 0.0f);
    }

    protected void setMesh3DToZBuffer(IMesh3D iMesh3D) {
        this.setMesh3D(iMesh3D);
    }

    protected void setMesh3DOctreeToZBuffer(IMesh3DOctree iMesh3DOctree) {
        this.setMesh3DOctree(iMesh3DOctree);
    }

    protected void prepareMesh3DLocalLight3DBuffer(IScene3D iScene3D, Mesh3D mesh3D) {
        super.prepareMesh3DLocalLight3DBuffer(iScene3D, mesh3D);
        this.setLights();
    }

    private void setLights() {
        this.gl.glEnable(16384);
        this.light0Val[0] = 1.0f;
        this.light0Val[1] = 1.0f;
        this.light0Val[2] = 1.0f;
        this.light0Val[3] = 1.0f;
        this.gl.glLightfv(16384, 4609, this.light0Val, 0);
        this.light0Val[0] = 0.0f;
        this.light0Val[1] = 0.0f;
        this.light0Val[2] = 0.0f;
        this.light0Val[3] = 1.0f;
        this.gl.glLightfv(16385, 4608, this.light0Val, 0);
        this.light0Pos[0] = (float)(-this.mesh3DLocalLight3DBuffer[0].azx);
        this.light0Pos[1] = (float)(-this.mesh3DLocalLight3DBuffer[0].azy);
        this.light0Pos[2] = (float)(-this.mesh3DLocalLight3DBuffer[0].azz);
        this.light0Pos[3] = 0.0f;
        this.gl.glLightfv(16384, 4611, this.light0Pos, 0);
        this.gl.glLightModeli(2897, 1);
    }

    protected int setFaces3DToZBuffer(IFace3D[] iFace3DArray, int n) {
        int n2 = iFace3DArray.length;
        int n3 = 0;
        if (n >= 0) {
            n3 = n;
            n2 = n + 1;
        }
        while (n3 < n2) {
            IFace3D iFace3D = iFace3DArray[n3];
            int n4 = 0;
            if (iFace3D.getMaterial() != null) {
                n4 |= 1;
                if (iFace3D.getMaterial().getDiffuseTexture() != null) {
                    n4 |= 0x1C;
                }
                if (iFace3D.getMaterial().getDiffuseTextureDetail() != null) {
                    n4 |= 0x20;
                }
            }
            n4 &= this.getRender3DModeFlags();
            int n5 = n4 &= this.cMesh3D.getRender3DModeFlags();
            this.setMaterial(iFace3D.getMaterial());
            if ((n5 & 1) != 0) {
                if (!this.lightEnabled) {
                    this.setGLTriangle(false);
                    this.gl.glEnable(2896);
                    this.lightEnabled = true;
                }
            } else if (this.lightEnabled) {
                this.setGLTriangle(false);
                this.gl.glDisable(2896);
                this.lightEnabled = false;
            }
            this.setTexture(iFace3D.getMaterial().getDiffuseTexture());
            this.setFace3D(iFace3D);
            ++n3;
        }
        return 1;
    }

    private void setGLTriangle(boolean bl) {
        if (bl && !this.glTriangleOn) {
            this.gl.glBegin(4);
            this.glTriangleOn = true;
        }
        if (!bl && this.glTriangleOn) {
            this.gl.glEnd();
            this.glTriangleOn = false;
        }
    }

    private void setFace3D(IFace3D iFace3D) {
        IVertex3D iVertex3D = iFace3D.getVertex3D0();
        IVertex3D iVertex3D2 = iFace3D.getVertex3D1();
        IVertex3D iVertex3D3 = iFace3D.getVertex3D2();
        this.setGLTriangle(true);
        this.gl.glNormal3f(iFace3D.getVertex3D0Nx(), iFace3D.getVertex3D0Ny(), iFace3D.getVertex3D0Nz());
        this.gl.glTexCoord2f(iFace3D.getMappingU(0), iFace3D.getMappingV(0));
        this.gl.glVertex3f((float)iVertex3D.getX(), (float)iVertex3D.getY(), (float)iVertex3D.getZ());
        this.gl.glNormal3f(iFace3D.getVertex3D1Nx(), iFace3D.getVertex3D1Ny(), iFace3D.getVertex3D1Nz());
        this.gl.glTexCoord2f(iFace3D.getMappingU(1), iFace3D.getMappingV(1));
        this.gl.glVertex3f((float)iVertex3D2.getX(), (float)iVertex3D2.getY(), (float)iVertex3D2.getZ());
        this.gl.glNormal3f(iFace3D.getVertex3D2Nx(), iFace3D.getVertex3D2Ny(), iFace3D.getVertex3D2Nz());
        this.gl.glTexCoord2f(iFace3D.getMappingU(2), iFace3D.getMappingV(2));
        this.gl.glVertex3f((float)iVertex3D3.getX(), (float)iVertex3D3.getY(), (float)iVertex3D3.getZ());
    }

    protected void compileMesh3D(IMesh3D iMesh3D) {
        Log.log((String)("Compile Mesh3D (JOGL):" + iMesh3D.getName()));
        CompiledMesh3D compiledMesh3D = this.compiledMeshes[iMesh3D.getId()];
        if (compiledMesh3D == null) {
            this.compiledMeshes[iMesh3D.getId()] = compiledMesh3D = new CompiledMesh3D((Mesh3D)iMesh3D);
        }
        int n = compiledMesh3D.idJOGL;
        this.cMesh3D = (Mesh3D)iMesh3D;
        if (n <= 0) {
            compiledMesh3D.idJOGL = n = this.gl.glGenLists(1);
        }
        if (iMesh3D.getMesh3DOctree() == null) {
            this.gl.glNewList(n, 4864);
            this.setGLTriangle(true);
            this.setFaces3DToZBuffer(iMesh3D.getFaces3D(), -1);
            this.setGLTriangle(false);
            this.gl.glEndList();
        }
        Log.log((String)"Compile Mesh3D (JOGL) - OK");
    }

    protected void compileMesh3DOctree(IMesh3DOctree iMesh3DOctree) {
        Log.log((String)"Compile Mesh3DOctree (JOGL):");
        CompiledMesh3DOctree compiledMesh3DOctree = this.compiledMeshes[iMesh3DOctree.getMesh3D().getId()].compiledMesh3DOctrees[iMesh3DOctree.getId()];
        int n = compiledMesh3DOctree.idJOGL;
        if (n <= 0) {
            compiledMesh3DOctree.idJOGL = n = this.gl.glGenLists(1);
        }
        this.gl.glNewList(n, 4864);
        this.setGLTriangle(true);
        this.setFaces3DToZBuffer(iMesh3DOctree.getFaces3D(), -1);
        this.setGLTriangle(false);
        this.gl.glEndList();
        Log.log((String)"Compile Mesh3DOctree (JOGL) - OK");
    }

    protected void compileMaterial(IMaterial iMaterial) {
        int n;
        Log.log((String)("Compile Material (JOGL):" + iMaterial.getName()));
        CompiledMaterial compiledMaterial = this.compiledMaterials[iMaterial.getId()];
        if (compiledMaterial == null) {
            this.compiledMaterials[iMaterial.getId()] = compiledMaterial = new CompiledMaterial((Material)iMaterial);
        }
        if ((n = compiledMaterial.idJOGL) <= 0) {
            compiledMaterial.idJOGL = n = this.gl.glGenLists(1);
        }
        this.gl.glNewList(n, 4864);
        IMaterial iMaterial2 = iMaterial;
        if (iMaterial2 != null) {
            this.matAmbient[0] = 0.0f;
            this.matAmbient[1] = 0.0f;
            this.matAmbient[2] = 0.0f;
            this.matAmbient[3] = 1.0f;
            this.gl.glMaterialfv(1032, 4608, this.matAmbient, 0);
            if (iMaterial2.getDiffuseTexture() == null || iMaterial2.getDiffuseTexture().getPixels() == null) {
                this.matDiffuse[0] = (float)(iMaterial2.getDiffuseColor() >> 16 & 0xFF) * 1.0f / 255.0f;
                this.matDiffuse[1] = (float)(iMaterial2.getDiffuseColor() >> 8 & 0xFF) * 1.0f / 255.0f;
                this.matDiffuse[2] = (float)(iMaterial2.getDiffuseColor() & 0xFF) * 1.0f / 255.0f;
                this.matDiffuse[3] = 1.0f;
            } else {
                this.matDiffuse[0] = 1.0f;
                this.matDiffuse[1] = 1.0f;
                this.matDiffuse[2] = 1.0f;
                this.matDiffuse[3] = 1.0f;
            }
            this.gl.glMaterialfv(1032, 4609, this.matDiffuse, 0);
            float f = (float)iMaterial2.getSpecularLevel() * 1.0f / 255.0f;
            this.matSpecular[0] = f * (float)(iMaterial2.getSpecularColor() >> 16 & 0xFF) * 1.0f / 255.0f;
            this.matSpecular[1] = f * (float)(iMaterial2.getSpecularColor() >> 8 & 0xFF) * 1.0f / 255.0f;
            this.matSpecular[2] = f * (float)(iMaterial2.getSpecularColor() & 0xFF) * 1.0f / 255.0f;
            this.matSpecular[3] = 1.0f;
            this.gl.glMaterialfv(1032, 4610, this.matSpecular, 0);
            this.gl.glMateriali(1032, 5633, iMaterial2.getSpecularPower());
        }
        this.gl.glEndList();
        Log.log((String)"Compile Material (JOGL) - OK");
    }

    protected void compileTexture(ITexture iTexture) {
        int n;
        Log.log((String)("Compile Texture (JOGL):" + iTexture.getName() + "(" + iTexture.getId() + ")"));
        if (iTexture.getPixels() == null) {
            return;
        }
        CompiledTexture compiledTexture = this.compiledTextures[iTexture.getId()];
        if (compiledTexture == null) {
            this.compiledTextures[iTexture.getId()] = compiledTexture = new CompiledTexture((Texture)iTexture);
        }
        if ((n = compiledTexture.idJOGL) <= 0) {
            IntBuffer intBuffer = IntBuffer.allocate(1);
            this.gl.glGenTextures(1, intBuffer);
            ((Buffer)intBuffer).rewind();
            compiledTexture.idJOGL = n = intBuffer.get();
        }
        this.gl.glBindTexture(3553, n);
        this.gl.glTexParameteri(3553, 10242, 10497);
        this.gl.glTexParameteri(3553, 10243, 10497);
        this.gl.glTexParameteri(3553, 10241, 4354);
        this.gl.glTexParameteri(3553, 10240, 4354);
        this.glu.gluBuild2DMipmaps(3553, 3, iTexture.getPixelsWidth(), iTexture.getPixelsHeight(), 32993, 5121, (Buffer)IntBuffer.wrap(iTexture.getPixels()));
        Log.log((String)"Compile Texture (JOGL) - OK");
    }

    private void initRender3DJOGL() {
        if (((Render2D)this).isPixelUpdateEnabled) {
            if (this.scene.isBackgroundEnabled()) {
                this.gl.glClearColor((float)(this.scene.getBackgroundColor() >> 16 & 0xFF) * 1.0f / 255.0f, (float)(this.scene.getBackgroundColor() >> 8 & 0xFF) * 1.0f / 255.0f, (float)(this.scene.getBackgroundColor() & 0xFF) * 1.0f / 255.0f, 0.0f);
            }
            this.gl.glClear(16640);
            this.gl.glDepthFunc(513);
        } else {
            this.gl.glClear(256);
            this.gl.glDepthFunc(512);
        }
        this.gl.glHint(3152, 4354);
        this.gl.glEnable(2929);
        this.gl.glEnable(2884);
        this.gl.glCullFace(1028);
        this.currentTexture = null;
        this.currentMaterial = null;
        this.textureEnabled = false;
        this.lightEnabled = false;
        this.gl.glDisable(3553);
        this.gl.glDisable(2896);
    }

    private void setCamera3D() {
        this.gl.glMatrixMode(5889);
        this.gl.glLoadIdentity();
        double d = this.zMin / this.focus;
        this.gl.glFrustum(-d / this.zoomX, d / this.zoomX, -d / this.zoomY, d / this.zoomY, this.zMin, (double)((float)Math.min(3.4028234663852886E38, this.zMax)));
        this.gl.glMatrixMode(5888);
    }

    private void setLight3D(ILight3D iLight3D) {
    }

    private void setMesh3D(IMesh3D iMesh3D) {
        int n = this.compiledMeshes[iMesh3D.getId()].idJOGL;
        this.gl.glCallList(n);
    }

    private void setMaterial(IMaterial iMaterial) {
        if (this.currentMaterial == iMaterial) {
            return;
        }
        this.currentMaterial = iMaterial;
        this.setGLTriangle(false);
        int n = this.compiledMaterials[iMaterial.getId()].idJOGL;
        this.gl.glCallList(n);
    }

    private void setMesh3DOctree(IMesh3DOctree iMesh3DOctree) {
        CompiledMesh3DOctree compiledMesh3DOctree = this.compiledMeshes[iMesh3DOctree.getMesh3D().getId()].compiledMesh3DOctrees[iMesh3DOctree.getId()];
        int n = compiledMesh3DOctree.idJOGL;
        this.gl.glCallList(n);
    }

    private void setTexture(ITexture iTexture) {
        if (this.currentTexture == iTexture) {
            return;
        }
        this.currentTexture = iTexture;
        this.setGLTriangle(false);
        if (this.currentTexture == null || this.compiledTextures[this.currentTexture.getId()] == null) {
            this.gl.glDisable(3553);
            this.textureEnabled = false;
            return;
        }
        this.gl.glEnable(3553);
        this.textureEnabled = true;
        int n = this.compiledTextures[this.currentTexture.getId()].idJOGL;
        this.gl.glBindTexture(3553, n);
    }

    protected void disposeMesh3D(IMesh3D iMesh3D) {
        Log.log((String)("Dispose Mesh3D (JOGL) " + iMesh3D.getName()));
        this.releaseMesh3D(iMesh3D);
        int n = iMesh3D.getId();
        CompiledMesh3D compiledMesh3D = this.compiledMeshes[n + 1];
        do {
            this.compiledMeshes[n++] = compiledMesh3D;
        } while ((compiledMesh3D = this.compiledMeshes[n + 1]) != null);
    }

    protected void disposeCamera3D(ICamera3D iCamera3D) {
        Log.log((String)("Dispose Camera3D (JOGL) : " + iCamera3D.getName()));
    }

    protected void disposeLight3D(ILight3D iLight3D) {
        Log.log((String)("Dispose Light3D (JOGL) : " + iLight3D.getName()));
    }

    protected void disposeTexture(ITexture iTexture) {
        Log.log((String)("Dispose ITexture (JOGL) : " + iTexture.getName()));
        this.releaseTexture(iTexture);
        int n = iTexture.getId();
        CompiledTexture compiledTexture = this.compiledTextures[n + 1];
        do {
            this.compiledTextures[n++] = compiledTexture;
        } while ((compiledTexture = this.compiledTextures[n + 1]) != null);
    }

    protected void disposeMaterial(IMaterial iMaterial) {
        Log.log((String)("Dispose Material (JOGL) : " + iMaterial.getName()));
        this.releaseMaterial(iMaterial);
        int n = iMaterial.getId();
        CompiledMaterial compiledMaterial = this.compiledMaterials[n + 1];
        do {
            this.compiledMaterials[n++] = compiledMaterial;
        } while ((compiledMaterial = this.compiledMaterials[n + 1]) != null);
    }

    private void releaseTexture(ITexture iTexture) {
        int[] nArray = new int[]{this.compiledTextures[iTexture.getId()].idJOGL};
        this.gl.glDeleteTextures(1, IntBuffer.wrap(nArray));
    }

    private void releaseMesh3D(IMesh3D iMesh3D) {
        int n = this.compiledMeshes[iMesh3D.getId()].idJOGL;
        this.gl.glDeleteLists(n, 1);
    }

    private void releaseMesh3DOctree(IMesh3DOctree iMesh3DOctree) {
        if (iMesh3DOctree.getNbFace3D() == 0) {
            return;
        }
        CompiledMesh3DOctree compiledMesh3DOctree = this.compiledMeshes[iMesh3DOctree.getMesh3D().getId()].compiledMesh3DOctrees[iMesh3DOctree.getId()];
        int n = compiledMesh3DOctree.idJOGL;
        this.gl.glDeleteLists(n, 1);
    }

    private void releaseMaterial(IMaterial iMaterial) {
        int n = this.compiledMaterials[iMaterial.getId()].idJOGL;
        this.gl.glDeleteLists(n, 1);
    }

    public String getImplementationName() {
        return "JOGL";
    }

    private void makeContentCurrent() {
        try {
            while (this.context.makeCurrent() == 0) {
                System.out.println("Context not yet current...");
                Thread.sleep(10L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.gl = gLAutoDrawable.getGL();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this.scene == null) {
            return;
        }
        super.renderScene3D(this.scene);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    class CompiledTexture
    extends CompiledJOGL {
        Texture texture;

        CompiledTexture(Texture texture) {
            this.texture = texture;
        }
    }

    class CompiledMaterial
    extends CompiledJOGL {
        Material material;

        CompiledMaterial(Material material) {
            this.material = material;
        }
    }

    class CompiledLight3D
    extends CompiledJOGL {
        Light3D light;

        CompiledLight3D(Light3D light3D) {
            this.light = light3D;
        }
    }

    class CompiledMesh3D
    extends CompiledJOGL {
        Mesh3D mesh;
        CompiledMesh3DOctree[] compiledMesh3DOctrees;

        CompiledMesh3D(Mesh3D mesh3D) {
            this.mesh = mesh3D;
            if (mesh3D.getMesh3DOctree() != null) {
                int n = 1 + mesh3D.getMesh3DOctree().getNbChildren(true);
                this.compiledMesh3DOctrees = new CompiledMesh3DOctree[n];
                IMesh3DOctree[] iMesh3DOctreeArray = mesh3D.getMesh3DOctree().getMesh3DOctreeArray((IMesh3DOctree[])new Mesh3DOctree[n]);
                for (int i = 0; i < n; ++i) {
                    this.compiledMesh3DOctrees[i] = new CompiledMesh3DOctree((Mesh3DOctree)iMesh3DOctreeArray[i]);
                }
            }
        }
    }

    class CompiledMesh3DOctree
    extends CompiledJOGL {
        Mesh3DOctree tree;

        CompiledMesh3DOctree(Mesh3DOctree mesh3DOctree) {
            this.tree = mesh3DOctree;
        }
    }

    class CompiledJOGL {
        int idJOGL = -1;

        CompiledJOGL() {
        }
    }
}

