/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.extension.jogl;

import java.awt.Canvas;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.glu.GLU;
import net.dzzd.access.IScene2D;
import net.dzzd.core.Render2D;

public final class Render2DJOGL
extends Render2D {
    private GLContext context;
    private GLCanvas canvas;
    private GL gl;
    private GLU glu;
    private IScene2D scene;

    public Canvas getCanvas() {
        return this.canvas;
    }

    public Render2DJOGL() throws Throwable {
        GLCapabilities gLCapabilities = new GLCapabilities();
        gLCapabilities.setRedBits(8);
        gLCapabilities.setBlueBits(8);
        gLCapabilities.setGreenBits(8);
        gLCapabilities.setAlphaBits(8);
        gLCapabilities.setDoubleBuffered(true);
        gLCapabilities.setHardwareAccelerated(true);
        this.canvas = new GLCanvas(gLCapabilities);
        this.canvas.setAutoSwapBufferMode(false);
        this.glu = new GLU();
        this.context = this.canvas.getContext();
        this.gl = this.context.getGL();
    }

    public void setSize(int n, int n2) {
        this.canvas.setSize(n, n2);
    }

    public void renderScene2D(IScene2D iScene2D) {
        this.scene = iScene2D;
        this.makeContentCurrent();
        this.gl.glDisable(2929);
        this.gl.glClearColor(0.0f, 0.0f, 1.0f, 0.0f);
        this.gl.glClear(16384);
        this.gl.glLoadIdentity();
        this.gl.glColor3f(1.0f, 0.0f, 0.0f);
        this.gl.glBegin(4);
        this.gl.glVertex3f(0.0f, 0.0f, 0.0f);
        this.gl.glVertex3f(1.0f, 0.0f, 0.0f);
        this.gl.glVertex3f(0.0f, 1.0f, 0.0f);
        this.gl.glEnd();
        this.gl.glColor3f(0.0f, 1.0f, 0.0f);
        this.context.release();
        if (this.isScreenUpdateEnabled) {
            this.canvas.swapBuffers();
        }
    }

    private void makeContentCurrent() {
        try {
            while (this.context.makeCurrent() == 0) {
                System.out.println("Context not yet current...");
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.gl = gLAutoDrawable.getGL();
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this.scene == null) {
            return;
        }
        super.renderScene2D(this.scene);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this.gl = gLAutoDrawable.getGL();
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
        this.gl = gLAutoDrawable.getGL();
    }
}

