/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.IAxis3D;
import net.dzzd.access.IPoint3D;
import net.dzzd.core.Point3D;

public final class Axis3D
implements IAxis3D,
Serializable {
    public static final long serialVersionUID = 1L;
    protected Point3D origine = new Point3D();
    protected Point3D axeX = new Point3D();
    protected Point3D axeY = new Point3D();
    protected Point3D axeZ = new Point3D();

    public Axis3D() {
        this.init();
    }

    IAxis3D normalize() {
        this.axeX.sub(this.origine).normalize().add(this.origine);
        this.axeY.sub(this.origine).normalize().add(this.origine);
        this.axeZ.sub(this.origine).normalize().add(this.origine);
        return this;
    }

    IAxis3D set(IPoint3D iPoint3D) {
        this.add(iPoint3D.getX(), iPoint3D.getY(), iPoint3D.getZ());
        return this;
    }

    IAxis3D getPosition(IPoint3D iPoint3D) {
        iPoint3D.setX(this.origine.x);
        iPoint3D.setY(this.origine.y);
        iPoint3D.setZ(this.origine.z);
        return this;
    }

    public IAxis3D toLocalAxis(IAxis3D iAxis3D) {
        IPoint3D iPoint3D = iAxis3D.getOrigin();
        IPoint3D iPoint3D2 = iAxis3D.getAX();
        IPoint3D iPoint3D3 = iAxis3D.getAY();
        IPoint3D iPoint3D4 = iAxis3D.getAZ();
        double d = iPoint3D.getX();
        double d2 = iPoint3D.getY();
        double d3 = iPoint3D.getZ();
        double d4 = iPoint3D2.getX() - d;
        double d5 = iPoint3D2.getY() - d2;
        double d6 = iPoint3D2.getZ() - d3;
        double d7 = iPoint3D3.getX() - d;
        double d8 = iPoint3D3.getY() - d2;
        double d9 = iPoint3D3.getZ() - d3;
        double d10 = iPoint3D4.getX() - d;
        double d11 = iPoint3D4.getY() - d2;
        double d12 = iPoint3D4.getZ() - d3;
        IPoint3D iPoint3D5 = this.getOrigin();
        double d13 = iPoint3D5.getX() - d;
        double d14 = iPoint3D5.getY() - d2;
        double d15 = iPoint3D5.getZ() - d3;
        iPoint3D5.setX(d4 * d13 + d5 * d14 + d6 * d15);
        iPoint3D5.setY(d7 * d13 + d8 * d14 + d9 * d15);
        iPoint3D5.setZ(d10 * d13 + d11 * d14 + d12 * d15);
        iPoint3D5 = this.getAX();
        d13 = iPoint3D5.getX() - d;
        d14 = iPoint3D5.getY() - d2;
        d15 = iPoint3D5.getZ() - d3;
        iPoint3D5.setX(d4 * d13 + d5 * d14 + d6 * d15);
        iPoint3D5.setY(d7 * d13 + d8 * d14 + d9 * d15);
        iPoint3D5.setZ(d10 * d13 + d11 * d14 + d12 * d15);
        iPoint3D5 = this.getAY();
        d13 = iPoint3D5.getX() - d;
        d14 = iPoint3D5.getY() - d2;
        d15 = iPoint3D5.getZ() - d3;
        iPoint3D5.setX(d4 * d13 + d5 * d14 + d6 * d15);
        iPoint3D5.setY(d7 * d13 + d8 * d14 + d9 * d15);
        iPoint3D5.setZ(d10 * d13 + d11 * d14 + d12 * d15);
        iPoint3D5 = this.getAZ();
        d13 = iPoint3D5.getX() - d;
        d14 = iPoint3D5.getY() - d2;
        d15 = iPoint3D5.getZ() - d3;
        iPoint3D5.setX(d4 * d13 + d5 * d14 + d6 * d15);
        iPoint3D5.setY(d7 * d13 + d8 * d14 + d9 * d15);
        iPoint3D5.setZ(d10 * d13 + d11 * d14 + d12 * d15);
        return this;
    }

    public IAxis3D toAxis(IAxis3D iAxis3D) {
        IPoint3D iPoint3D = iAxis3D.getOrigin();
        IPoint3D iPoint3D2 = iAxis3D.getAX();
        IPoint3D iPoint3D3 = iAxis3D.getAY();
        IPoint3D iPoint3D4 = iAxis3D.getAZ();
        double d = iPoint3D.getX();
        double d2 = iPoint3D.getY();
        double d3 = iPoint3D.getZ();
        double d4 = iPoint3D2.getX() - d;
        double d5 = iPoint3D2.getY() - d2;
        double d6 = iPoint3D2.getZ() - d3;
        double d7 = iPoint3D3.getX() - d;
        double d8 = iPoint3D3.getY() - d2;
        double d9 = iPoint3D3.getZ() - d3;
        double d10 = iPoint3D4.getX() - d;
        double d11 = iPoint3D4.getY() - d2;
        double d12 = iPoint3D4.getZ() - d3;
        IPoint3D iPoint3D5 = this.getOrigin();
        double d13 = iPoint3D5.getX();
        double d14 = iPoint3D5.getY();
        double d15 = iPoint3D5.getZ();
        iPoint3D5.setX(d + d4 * d13 + d7 * d14 + d10 * d15);
        iPoint3D5.setY(d2 + d5 * d13 + d8 * d14 + d11 * d15);
        iPoint3D5.setZ(d3 + d6 * d13 + d9 * d14 + d12 * d15);
        iPoint3D5 = this.getAX();
        d13 = iPoint3D5.getX();
        d14 = iPoint3D5.getY();
        d15 = iPoint3D5.getZ();
        iPoint3D5.setX(d + d4 * d13 + d7 * d14 + d10 * d15);
        iPoint3D5.setY(d2 + d5 * d13 + d8 * d14 + d11 * d15);
        iPoint3D5.setZ(d3 + d6 * d13 + d9 * d14 + d12 * d15);
        iPoint3D5 = this.getAY();
        d13 = iPoint3D5.getX();
        d14 = iPoint3D5.getY();
        d15 = iPoint3D5.getZ();
        iPoint3D5.setX(d + d4 * d13 + d7 * d14 + d10 * d15);
        iPoint3D5.setY(d2 + d5 * d13 + d8 * d14 + d11 * d15);
        iPoint3D5.setZ(d3 + d6 * d13 + d9 * d14 + d12 * d15);
        iPoint3D5 = this.getAZ();
        d13 = iPoint3D5.getX();
        d14 = iPoint3D5.getY();
        d15 = iPoint3D5.getZ();
        iPoint3D5.setX(d + d4 * d13 + d7 * d14 + d10 * d15);
        iPoint3D5.setY(d2 + d5 * d13 + d8 * d14 + d11 * d15);
        iPoint3D5.setZ(d3 + d6 * d13 + d9 * d14 + d12 * d15);
        return this;
    }

    public IAxis3D init() {
        this.origine.set(0.0, 0.0, 0.0);
        this.axeX.set(1.0, 0.0, 0.0);
        this.axeY.set(0.0, 1.0, 0.0);
        this.axeZ.set(0.0, 0.0, 1.0);
        return this;
    }

    public IPoint3D getAX() {
        return this.axeX;
    }

    public IPoint3D getAY() {
        return this.axeY;
    }

    public IPoint3D getAZ() {
        return this.axeZ;
    }

    public IPoint3D getOrigin() {
        return this.origine;
    }

    public IAxis3D copy(IAxis3D iAxis3D) {
        this.origine.copy(iAxis3D.getOrigin());
        this.axeX.copy(iAxis3D.getAX());
        this.axeY.copy(iAxis3D.getAY());
        this.axeZ.copy(iAxis3D.getAZ());
        return this;
    }

    public IAxis3D add(double d, double d2, double d3) {
        this.origine.add(d, d2, d3);
        this.axeX.add(d, d2, d3);
        this.axeY.add(d, d2, d3);
        this.axeZ.add(d, d2, d3);
        return this;
    }

    public IAxis3D sub(double d, double d2, double d3) {
        return this.add(-d, -d2, -d3);
    }

    public IAxis3D add(IPoint3D iPoint3D) {
        return this.add(iPoint3D.getX(), iPoint3D.getY(), iPoint3D.getZ());
    }

    public IAxis3D sub(IPoint3D iPoint3D) {
        return this.add(-iPoint3D.getX(), -iPoint3D.getY(), -iPoint3D.getZ());
    }

    public IAxis3D rotateX(double d) {
        this.origine.rotateX(d);
        this.axeX.rotateX(d);
        this.axeY.rotateX(d);
        this.axeZ.rotateX(d);
        return this;
    }

    public IAxis3D rotateY(double d) {
        this.origine.rotateY(d);
        this.axeX.rotateY(d);
        this.axeY.rotateY(d);
        this.axeZ.rotateY(d);
        return this;
    }

    public IAxis3D rotateZ(double d) {
        this.origine.rotateZ(d);
        this.axeX.rotateZ(d);
        this.axeY.rotateZ(d);
        this.axeZ.rotateZ(d);
        return this;
    }

    public IAxis3D rotate(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        this.add(-d2, -d3, -d4);
        this.rotate(d, d5 - d2, d6 - d3, d7 - d4);
        this.add(d2, d3, d4);
        return this;
    }

    public IAxis3D rotate(double d, IPoint3D iPoint3D, IPoint3D iPoint3D2) {
        return this.rotate(d, iPoint3D.getX(), iPoint3D.getY(), iPoint3D.getZ(), iPoint3D2.getX(), iPoint3D2.getY(), iPoint3D2.getZ());
    }

    public IAxis3D rotate(double d, double d2, double d3, double d4, IPoint3D iPoint3D) {
        return this.rotate(d, d2, d3, d4, iPoint3D.getX(), iPoint3D.getY(), iPoint3D.getZ());
    }

    public IAxis3D rotate(double d, IPoint3D iPoint3D) {
        return this.rotate(d, iPoint3D.getX(), iPoint3D.getY(), iPoint3D.getY());
    }

    public IAxis3D rotate(double d, double d2, double d3, double d4) {
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        if (d5 == 0.0) {
            return this;
        }
        double d6 = 1.0 / d5;
        double d7 = Math.sqrt((d2 *= d6) * d2 + (d4 *= d6) * d4);
        double d8 = Math.asin(d3 *= d6);
        double d9 = 0.0;
        if (d7 != 0.0) {
            d9 = -Math.acos(d4 / d7);
            if (d2 < 0.0) {
                d9 = -d9;
            }
        } else {
            d8 = d3 > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
            d9 = 0.0;
        }
        this.rotateY(-d9);
        this.rotateX(-d8);
        this.rotateZ(d);
        this.rotateX(d8);
        this.rotateY(d9);
        return this;
    }

    IAxis3D getRotationXYZ(IPoint3D iPoint3D) {
        this.getRotationXZY(iPoint3D);
        double d = iPoint3D.getY();
        iPoint3D.setY(iPoint3D.getZ());
        iPoint3D.setZ(d);
        return this;
    }

    public IAxis3D getRotationXZY(IPoint3D iPoint3D) {
        Point3D point3D = this.origine;
        Point3D point3D2 = this.axeX;
        Point3D point3D3 = this.axeY;
        Point3D point3D4 = this.axeZ;
        double d = point3D.x;
        double d2 = point3D.y;
        double d3 = point3D.z;
        double d4 = point3D2.x - d;
        double d5 = point3D2.y - d2;
        double d6 = point3D2.z - d3;
        double d7 = point3D3.x - d;
        double d8 = point3D3.y - d2;
        double d9 = point3D3.z - d3;
        double d10 = point3D4.x - d;
        double d11 = point3D4.y - d2;
        double d12 = point3D4.z - d3;
        this.getRotationXZY(d4, d5, d6, d7, d8, d9, d10, d11, d12, iPoint3D);
        return this;
    }

    public IAxis3D set(IPoint3D iPoint3D, IPoint3D iPoint3D2, IPoint3D iPoint3D3) {
        Point3D point3D = (Point3D)iPoint3D;
        Point3D point3D2 = (Point3D)iPoint3D2;
        Point3D point3D3 = (Point3D)iPoint3D3;
        this.add(-point3D.x, -point3D.y, -point3D.z);
        this.rotateX(point3D3.x);
        this.rotateZ(point3D3.z);
        this.rotateY(point3D3.y);
        this.add(point3D2.x, point3D2.y, point3D2.z);
        return this;
    }

    public IAxis3D set(IPoint3D iPoint3D, IPoint3D iPoint3D2) {
        Point3D point3D = (Point3D)iPoint3D;
        Point3D point3D2 = (Point3D)iPoint3D2;
        this.rotateX(point3D2.x);
        this.rotateZ(point3D2.z);
        this.rotateY(point3D2.y);
        this.add(point3D.x, point3D.y, point3D.z);
        return this;
    }

    private void getRotationXZY(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, IPoint3D iPoint3D) {
        double d10 = Math.asin(-d2);
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = Math.sqrt(d * d + d3 * d3);
        double d14 = 0.0;
        if (d13 > 0.0) {
            double d15;
            d14 = 1.0 / d13;
            double d16 = d5 * d14;
            if (d16 > 1.0) {
                d16 = 1.0;
            }
            if (d16 < -1.0) {
                d16 = -1.0;
            }
            d11 = Math.acos(d16);
            if (d8 < 0.0) {
                d11 = -d11;
            }
            if ((d15 = d * d14) > 1.0) {
                d15 = 1.0;
            }
            if (d15 < -1.0) {
                d15 = -1.0;
            }
            d12 = Math.acos(d * d14);
            if (d3 < 0.0) {
                d12 = -d12;
            }
        } else {
            d11 = d2 < 0.0 ? Math.atan2(d7, d9) : Math.atan2(-d7, d9);
        }
        if (Double.isNaN(d11) || Double.isNaN(d12) || Double.isNaN(d10)) {
            System.out.println("RX = " + d11);
            System.out.println("RY = " + d12);
            System.out.println("RZ = " + d10);
            System.out.println("AXNormeOnPlaneXZ = " + d13);
            System.out.println("iAXNormeOnPlaneXZ = " + d14);
            System.out.println("AYy*iAXNormeOnPlaneXZ = " + d5 * d14);
            System.out.println("AXx*iAXNormeOnPlaneXZ = " + d * d14);
        }
        if (Math.abs(d11) > 1.5707963267948966 && Math.abs(d12) > 1.5707963267948966) {
            d11 -= Math.PI;
            d12 -= Math.PI;
            d10 = Math.PI - d10;
        }
        iPoint3D.set(d11, d12, d10);
    }
}

