/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;
import net.dzzd.core.Axis3D;
import net.dzzd.core.Face3D;
import net.dzzd.core.MappingUV;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.PixelsBufferBI;
import net.dzzd.core.Point3D;
import net.dzzd.core.Render2D;
import net.dzzd.core.Render3D;
import net.dzzd.core.Render3DSW;
import net.dzzd.core.Texture;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;

class Drawer {
    public int[] debug = new int[40000];
    public int nbDebug = 0;
    static int[] iZ;
    static int[] log2;
    static int[] normalMap;
    private boolean useMIS;
    private MemoryImageSource imageMemoire;
    private Image image;
    private int[] pixels;
    private int[] rPixels;
    private int[] zBuffer;
    private int[] zBufferF;
    private int[] softBuffer;
    private int[] softBufferR;
    private int renderPixelWidth;
    private int renderPixelHeight;
    private double renderPixelWidthDiv2;
    private double renderPixelHeightDiv2;
    private double iFocus;
    private double iZoomX;
    private double iZoomY;
    private double zoomX;
    private double zoomY;
    private int antialias;
    private int nbSoftPoint;
    private int lastSoftPoint;
    private int renderMode;
    private int faceRenderMode;
    private double textureLevel;
    private Render3D.Mesh3DLight3D[] mesh3DLocalLight3DBuffer;
    private Mesh3D objRef;
    private Face3D polRef;
    private Material material;
    private MappingUV mapping;
    Render3DSW.CompiledMesh3D compiledMesh;
    Render3DSW.CompiledFace compiledFace;
    Render3DSW.CompiledMaterial compiledMaterial;
    private double ox;
    private double oy;
    private double oz;
    private double axx;
    private double axy;
    private double axz;
    private double ayx;
    private double ayy;
    private double ayz;
    private double azx;
    private double azy;
    private double azz;
    private int XBF;
    private int YBF;
    private int startXYBF;
    private int endXYBF;
    private double iZA;
    private double iZB;
    private double iZC;
    private double iUBA;
    private double iUBB;
    private double iUBC;
    private double iVBA;
    private double iVBB;
    private double iVBC;
    private double iWBA;
    private double iWBB;
    private double iWBC;
    private double incUBDivZ;
    private double incVBDivZ;
    private double incWBDivZ;
    private double iUA;
    private double iUB;
    private double iUC;
    private double iVA;
    private double iVB;
    private double iVC;
    private double incUDivZ;
    private double incVDivZ;
    private double dpDivZ;
    private int[] specularLightMap;
    private int[] dTexturePixels;
    private int ddecalWidth;
    private int ddecalHeight;
    private int dmaskHeight;
    private int dmaskWidth;
    private int dLargeurImage;
    private int dHauteurImage;
    private int dNbMipMap;
    private int[][] dMipMap;
    private int[] bTexturePixels;
    private int bdecalWidth;
    private int bdecalHeight;
    private int bmaskHeight;
    private int bmaskWidth;
    private int bLargeurImage;
    private int bHauteurImage;
    private int bNbMipMap;
    private int[][] bMipMap;
    private int[] eTexturePixels;
    private int edecalWidth;
    private int edecalHeight;
    private int emaskHeight;
    private int emaskWidth;
    private int eLargeurImage;
    private int eHauteurImage;
    private int eNbMipMap;
    private int[][] eMipMap;
    private double currentTextureLevel;
    private int fogColor;
    private int startXY;
    private int endXY;
    private int iZi;
    private int incIzi;
    private int scaleZ;
    private int uniformIz;
    private int incUniformIz;
    private int uniIz;
    private int[] normalPixels;
    private int[] envPixels;
    private int numMipMap;
    private int[] texturePixels;
    private int decalWidth;
    private int decalHeight;
    private int maskHeight;
    private int maskWidth;
    private int largeurImage;
    private int hauteurImage;
    private int endXMipMap;
    private int maskUV;
    private int decUBX;
    private int decVBX;
    private int decU;
    private int decV;
    private int ofsU;
    private int sizeU;
    private int ofsV;
    private int sizeV;
    private int ofsWB;
    private int sizeWB;
    private int ofsUB;
    private int sizeUB;
    private int ofsVB;
    private int sizeVB;
    private int lastColor;
    private int co1 = 0;
    private int co2 = 0;
    private int co3 = 0;
    private int co4 = 0;
    private int no1 = 0;
    private int no2 = 0;
    private int no3 = 0;
    private int no4 = 0;
    private int envColor = 0;
    private int alphaLevel = 0;
    private int normal = 0;
    private int pixelColor = 0;
    private int rZ;
    private int rDiffuseTexel;
    private int rNormalTexel;
    private int rEnvironmentTexel;
    private int rDiffuseLight;
    private int rSpecularColor;
    int f24;
    int f23;
    int f14;
    int f13;
    boolean useDiffuseTexture;
    boolean useNormalTexture;
    boolean useEnvironmentTexure;

    Drawer() {
    }

    public final void setBuffers(Render3DSW render3DSW, int[] nArray, int[] nArray2) {
        Log.log("Drawer.setBuffers() : ");
        this.antialias = render3DSW.antialias;
        this.renderPixelWidth = render3DSW.getWidth();
        this.renderPixelHeight = render3DSW.getHeight();
        if ((this.antialias & 2) != 0) {
            this.renderPixelWidth <<= 1;
        }
        if ((this.antialias & 4) != 0) {
            this.renderPixelHeight <<= 1;
        }
        this.renderPixelWidthDiv2 = this.renderPixelWidth >> 1;
        this.renderPixelHeightDiv2 = this.renderPixelHeight >> 1;
        this.initPixelsBuffer(render3DSW.viewPixelWidth, render3DSW.viewPixelHeight);
        this.rPixels = this.antialias > 1 ? new int[this.renderPixelWidth * this.renderPixelHeight] : this.pixels;
        this.zBuffer = nArray;
        this.zBufferF = nArray2;
        this.softBuffer = new int[this.renderPixelWidth * this.renderPixelHeight >> 2];
        this.softBufferR = new int[this.renderPixelWidth * this.renderPixelHeight >> 2];
    }

    public final void setRender3DSW(Render3DSW render3DSW) {
        this.renderMode = render3DSW.render3DMode;
        this.iFocus = render3DSW.iFocus;
        this.iZoomX = render3DSW.iZoomX;
        this.iZoomY = render3DSW.iZoomY;
        this.zoomX = 1.0 / this.iZoomX;
        this.zoomY = 1.0 / this.iZoomY;
        this.textureLevel = 3.0;
        this.mesh3DLocalLight3DBuffer = render3DSW.mesh3DLocalLight3DBuffer;
        this.nbSoftPoint = 0;
    }

    public final void drawBackground(int n, int n2, int n3) {
        this.setStartSegment(n);
        this.setEndSegment(n2);
        n3 |= 0xFF000000;
        do {
            int n4 = (this.renderPixelHeight - this.YBF - 1) * this.renderPixelWidth;
            int n5 = this.YBF * this.renderPixelWidth;
            int n6 = this.XBF;
            int n7 = n4 + n6;
            int n8 = n5 + n6;
            int n9 = this.zBuffer[n8];
            int n10 = n9 >> 16 & 0xFF;
            double d = ((double)this.YBF - this.renderPixelHeightDiv2) * this.iZoomY;
            int n11 = n4 + (n9 &= 0xFFFF);
            while (n7 < n11) {
                this.rPixels[n7++] = n3;
            }
            if (this.XBF <= 0 || (this.antialias & 1) == 0) continue;
            this.softBuffer[this.nbSoftPoint] = n4 + this.XBF;
            this.softBufferR[this.nbSoftPoint++] = n10;
        } while (this.nextSegment());
    }

    private final void setStartSegment(int n) {
        this.XBF = n;
        this.YBF = this.XBF >> 16 & 0xFFFF;
        this.XBF &= 0xFFFF;
        this.startXYBF = this.XBF + this.YBF * this.renderPixelWidth;
    }

    private final boolean nextSegment() {
        this.XBF = this.zBufferF[this.startXYBF];
        this.YBF = this.XBF >> 16 & 0xFFFF;
        this.XBF &= 0xFFFF;
        this.startXYBF = this.XBF + this.YBF * this.renderPixelWidth;
        return this.startXYBF != this.endXYBF;
    }

    private final void setEndSegment(int n) {
        int n2 = n;
        int n3 = n2 >> 16 & 0xFFFF;
        int n4 = (n3 *= this.renderPixelWidth) + (n2 &= 0xFFFF);
        n2 = this.zBufferF[n4];
        n3 = n2 >> 16 & 0xFFFF;
        this.endXYBF = (n3 *= this.renderPixelWidth) + (n2 &= 0xFFFF);
    }

    public final void setMesh3D(Mesh3D mesh3D) {
        this.objRef = mesh3D;
        Axis3D axis3D = mesh3D.axes;
        Point3D point3D = axis3D.axeX;
        Point3D point3D2 = axis3D.axeY;
        Point3D point3D3 = axis3D.axeZ;
        Point3D point3D4 = axis3D.origine;
        this.ox = point3D4.x;
        this.oy = point3D4.y;
        this.oz = point3D4.z;
        this.axx = point3D.x - this.ox;
        this.axy = point3D.y - this.oy;
        this.axz = point3D.z - this.oz;
        this.ayx = point3D2.x - this.ox;
        this.ayy = point3D2.y - this.oy;
        this.ayz = point3D2.z - this.oz;
        this.azx = point3D3.x - this.ox;
        this.azy = point3D3.y - this.oy;
        this.azz = point3D3.z - this.oz;
    }

    public final void drawFace3D(Render3DSW.CompiledMesh3D compiledMesh3D, Render3DSW.CompiledFace compiledFace, boolean bl) {
        double d;
        double d2;
        double d3;
        this.compiledMesh = compiledMesh3D;
        this.compiledFace = compiledFace;
        this.compiledMaterial = compiledFace.compiledMaterial;
        this.polRef = this.compiledFace.face;
        this.material = this.polRef.material;
        this.mapping = this.material != null ? this.material.mapping : null;
        this.setStartSegment(this.compiledFace.firstRenderOffset);
        this.setEndSegment(this.compiledFace.lastRenderOffset);
        int n = 0;
        if (this.material != null) {
            this.rDiffuseTexel = this.material.diffuseColor;
            this.alphaLevel = this.material.alphaLevel;
            this.specularLightMap = this.compiledMaterial.specularLightMap;
            if (this.specularLightMap != null) {
                n |= 3;
                if (this.material.diffuseTexture != null && this.material.diffuseTexture.pixels != null) {
                    n |= 0x1C;
                    if (this.material.diffuseTextureDetail != null && this.material.diffuseTextureDetail.pixels != null) {
                        n |= 0x20;
                    }
                }
                if (this.material.bumpNormalTexture != null && this.material.bumpNormalTexture.pixels != null) {
                    n |= 0x98;
                }
                if (this.material.envTexture != null && this.material.envTexture.pixels != null) {
                    n |= 0x118;
                }
            }
        }
        n &= this.renderMode;
        this.faceRenderMode = n &= this.objRef.renderMode;
        this.currentTextureLevel = 0.0;
        if ((this.faceRenderMode & 8) != 0) {
            this.currentTextureLevel = this.textureLevel;
        }
        Vertex3D vertex3D = this.polRef.p0;
        Vertex3D vertex3D2 = this.polRef.p1;
        Vertex3D vertex3D3 = this.polRef.p2;
        double[] dArray = compiledMesh3D.xp;
        double[] dArray2 = compiledMesh3D.yp;
        double[] dArray3 = compiledMesh3D.zp;
        int n2 = vertex3D.id;
        int n3 = vertex3D2.id;
        int n4 = vertex3D3.id;
        double d4 = dArray[n2];
        double d5 = dArray2[n2];
        double d6 = dArray3[n2];
        double d7 = dArray[n3];
        double d8 = dArray2[n3];
        double d9 = dArray3[n3];
        double d10 = dArray[n4];
        double d11 = dArray2[n4];
        double d12 = dArray3[n4];
        double d13 = this.polRef.p0nx;
        double d14 = this.polRef.p0ny;
        double d15 = this.polRef.p0nz;
        double d16 = this.polRef.p1nx;
        double d17 = this.polRef.p1ny;
        double d18 = this.polRef.p1nz;
        double d19 = this.polRef.p2nx;
        double d20 = this.polRef.p2ny;
        double d21 = this.polRef.p2nz;
        double d22 = 1.0 / (d5 * (d10 - d7) + d8 * (d4 - d10) + d11 * (d7 - d4));
        if (Double.isNaN(d22)) {
            Log.log("Oups");
        }
        if (Double.isInfinite(d22)) {
            Log.log("Oups");
        }
        double d23 = (double)this.polRef.pa + vertex3D.x;
        double d24 = (double)this.polRef.pb + vertex3D.y;
        double d25 = (double)this.polRef.pc + vertex3D.z;
        double d26 = this.compiledFace.iD;
        double d27 = this.compiledFace.a * d26;
        double d28 = this.compiledFace.b * d26;
        double d29 = this.compiledFace.c * d26;
        this.iZA = this.compiledFace.iZA;
        this.iZB = this.compiledFace.iZB;
        this.iZC = this.compiledFace.iZC;
        if (d13 * (double)this.polRef.pa + d14 * (double)this.polRef.pb + d15 * (double)this.polRef.pc > 0.99 && d16 * (double)this.polRef.pa + d17 * (double)this.polRef.pb + d18 * (double)this.polRef.pc > 0.99 && d19 * (double)this.polRef.pa + d20 * (double)this.polRef.pb + d21 * (double)this.polRef.pc > 0.99) {
            this.faceRenderMode |= 0x40;
        }
        double d30 = this.mesh3DLocalLight3DBuffer[0].axx;
        double d31 = this.mesh3DLocalLight3DBuffer[0].axy;
        double d32 = this.mesh3DLocalLight3DBuffer[0].axz;
        double d33 = this.mesh3DLocalLight3DBuffer[0].ayx;
        double d34 = this.mesh3DLocalLight3DBuffer[0].ayy;
        double d35 = this.mesh3DLocalLight3DBuffer[0].ayz;
        double d36 = this.mesh3DLocalLight3DBuffer[0].azx;
        double d37 = this.mesh3DLocalLight3DBuffer[0].azy;
        double d38 = this.mesh3DLocalLight3DBuffer[0].azz;
        double d39 = 0.0;
        double d40 = 0.0;
        double d41 = 0.0;
        double d42 = 0.0;
        double d43 = 0.0;
        double d44 = 0.0;
        double d45 = 1.0;
        double d46 = 1.0;
        double d47 = 1.0;
        if ((this.faceRenderMode & 0x80) == 0) {
            d39 = d30 * d13 + d31 * d14 + d32 * d15;
            d40 = d30 * d16 + d31 * d17 + d32 * d18;
            d41 = d30 * d19 + d31 * d20 + d32 * d21;
            d42 = d33 * d13 + d34 * d14 + d35 * d15;
            d43 = d33 * d16 + d34 * d17 + d35 * d18;
            d44 = d33 * d19 + d34 * d20 + d35 * d21;
            d45 = d36 * d13 + d37 * d14 + d38 * d15;
            d46 = d36 * d16 + d37 * d17 + d38 * d18;
            d47 = d36 * d19 + d37 * d20 + d38 * d21;
        } else {
            d3 = this.compiledFace.p0tx;
            d2 = this.compiledFace.p0ty;
            d = this.compiledFace.p0tz;
            double d48 = this.compiledFace.p1tx;
            double d49 = this.compiledFace.p1ty;
            double d50 = this.compiledFace.p1tz;
            double d51 = this.compiledFace.p2tx;
            double d52 = this.compiledFace.p2ty;
            double d53 = this.compiledFace.p2tz;
            double d54 = this.compiledFace.p0bx;
            double d55 = this.compiledFace.p0by;
            double d56 = this.compiledFace.p0bz;
            double d57 = this.compiledFace.p1bx;
            double d58 = this.compiledFace.p1by;
            double d59 = this.compiledFace.p1bz;
            double d60 = this.compiledFace.p2bx;
            double d61 = this.compiledFace.p2by;
            double d62 = this.compiledFace.p2bz;
            d39 = d36 * d3 + d37 * d2 + d38 * d;
            d42 = d36 * d54 + d37 * d55 + d38 * d56;
            d45 = d36 * d13 + d37 * d14 + d38 * d15;
            d40 = d36 * d48 + d37 * d49 + d38 * d50;
            d43 = d36 * d57 + d37 * d58 + d38 * d59;
            d46 = d36 * d16 + d37 * d17 + d38 * d18;
            d41 = d36 * d51 + d37 * d52 + d38 * d53;
            d44 = d36 * d60 + d37 * d61 + d38 * d62;
            d47 = d36 * d19 + d37 * d20 + d38 * d21;
        }
        d3 = -d39 * 0.5;
        d2 = -d40 * 0.5;
        d = -d41 * 0.5;
        this.iUBA = (d5 * (d - d2) + d8 * (d3 - d) + d11 * (d2 - d3)) * d22;
        this.iUBB = (d4 * (d2 - d) + d7 * (d - d3) + d10 * (d3 - d2)) * d22;
        this.iUBC = (d5 * (d2 * d10 - d * d7) + d8 * (d * d4 - d3 * d10) + d11 * (d3 * d7 - d2 * d4)) * d22;
        this.iUBA -= this.iUBC * d27;
        this.iUBB -= this.iUBC * d28;
        this.iUBC = -this.iUBC * d29;
        this.iUBA *= this.iFocus;
        this.iUBB *= this.iFocus;
        d3 = -d42 * 0.5;
        d2 = -d43 * 0.5;
        d = -d44 * 0.5;
        this.iVBA = (d5 * (d - d2) + d8 * (d3 - d) + d11 * (d2 - d3)) * d22;
        this.iVBB = (d4 * (d2 - d) + d7 * (d - d3) + d10 * (d3 - d2)) * d22;
        this.iVBC = (d5 * (d2 * d10 - d * d7) + d8 * (d * d4 - d3 * d10) + d11 * (d3 * d7 - d2 * d4)) * d22;
        this.iVBA -= this.iVBC * d27;
        this.iVBB -= this.iVBC * d28;
        this.iVBC = -this.iVBC * d29;
        this.iVBA *= this.iFocus;
        this.iVBB *= this.iFocus;
        d3 = -d45 * 0.5;
        d2 = -d46 * 0.5;
        d = -d47 * 0.5;
        this.iWBA = (d5 * (d - d2) + d8 * (d3 - d) + d11 * (d2 - d3)) * d22;
        this.iWBB = (d4 * (d2 - d) + d7 * (d - d3) + d10 * (d3 - d2)) * d22;
        this.iWBC = (d5 * (d2 * d10 - d * d7) + d8 * (d * d4 - d3 * d10) + d11 * (d3 * d7 - d2 * d4)) * d22;
        this.iWBA -= this.iWBC * d27;
        this.iWBB -= this.iWBC * d28;
        this.iWBC = -this.iWBC * d29;
        this.iWBA *= this.iFocus;
        this.iWBB *= this.iFocus;
        this.incUBDivZ = this.iUBA * this.iZoomX;
        this.incVBDivZ = this.iVBA * this.iZoomX;
        this.incWBDivZ = this.iWBA * this.iZoomX;
        Texture texture = null;
        if (this.material != null) {
            this.eTexturePixels = null;
            if (this.material.envTexture != null && this.material.envTexture.pixels != null) {
                texture = this.material.envTexture;
                this.eTexturePixels = texture.pixels;
                this.edecalWidth = texture.decalWidth;
                this.edecalHeight = texture.decalHeight;
                this.emaskHeight = texture.maskHeight;
                this.emaskWidth = texture.maskWidth;
                this.eLargeurImage = texture.width;
                this.eHauteurImage = texture.height;
                this.eNbMipMap = texture.nbMipMap;
                this.eMipMap = texture.mipMap;
            }
            this.bTexturePixels = null;
            if (this.material.bumpNormalTexture != null && this.material.bumpNormalTexture.pixels != null) {
                texture = this.material.bumpNormalTexture;
                this.bTexturePixels = texture.pixels;
                this.bdecalWidth = texture.decalWidth;
                this.bdecalHeight = texture.decalHeight;
                this.bmaskHeight = texture.maskHeight;
                this.bmaskWidth = texture.maskWidth;
                this.bLargeurImage = texture.width;
                this.bHauteurImage = texture.height;
                this.bNbMipMap = texture.nbMipMap;
                this.bMipMap = texture.mipMap;
            }
            this.dTexturePixels = null;
            if (this.material.diffuseTexture != null && this.material.diffuseTexture.pixels != null) {
                texture = this.material.diffuseTexture;
                this.dTexturePixels = texture.pixels;
                this.ddecalWidth = texture.decalWidth;
                this.ddecalHeight = texture.decalHeight;
                this.dmaskHeight = texture.maskHeight;
                this.dmaskWidth = texture.maskWidth;
                this.dLargeurImage = texture.width;
                this.dHauteurImage = texture.height;
                this.dNbMipMap = texture.nbMipMap;
                this.dMipMap = texture.mipMap;
            }
            if (this.dTexturePixels != null || this.bTexturePixels != null) {
                double d63 = this.polRef.u0 * this.mapping.zoomU + this.mapping.ofsU;
                double d64 = this.polRef.u1 * this.mapping.zoomU + this.mapping.ofsU;
                double d65 = this.polRef.u2 * this.mapping.zoomU + this.mapping.ofsU;
                double d66 = this.polRef.v0 * this.mapping.zoomV + this.mapping.ofsV;
                double d67 = this.polRef.v1 * this.mapping.zoomV + this.mapping.ofsV;
                double d68 = this.polRef.v2 * this.mapping.zoomV + this.mapping.ofsV;
                this.iUA = (d5 * (d65 - d64) + d8 * (d63 - d65) + d11 * (d64 - d63)) * d22;
                this.iUB = (-d4 * (d65 - d64) - d7 * (d63 - d65) - d10 * (d64 - d63)) * d22;
                this.iUC = (d5 * (d64 * d10 - d65 * d7) + d8 * (d65 * d4 - d63 * d10) + d11 * (d63 * d7 - d64 * d4)) * d22;
                this.iUA -= this.iUC * d27;
                this.iUB -= this.iUC * d28;
                this.iUC = -this.iUC * d29;
                this.iUA *= this.iFocus;
                this.iUB *= this.iFocus;
                this.iVA = (d5 * (d68 - d67) + d8 * (d66 - d68) + d11 * (d67 - d66)) * d22;
                this.iVB = (-d4 * (d68 - d67) - d7 * (d66 - d68) - d10 * (d67 - d66)) * d22;
                this.iVC = (d5 * (d67 * d10 - d68 * d7) + d8 * (d68 * d4 - d66 * d10) + d11 * (d66 * d7 - d67 * d4)) * d22;
                this.iVA -= this.iVC * d27;
                this.iVB -= this.iVC * d28;
                this.iVC = -this.iVC * d29;
                this.iVA *= this.iFocus;
                this.iVB *= this.iFocus;
                double d69 = 1.0;
                double d70 = -this.iZA / this.iZB;
                double d71 = d69 * this.zoomX;
                double d72 = d70 * this.zoomY;
                if (d71 < 0.0) {
                    d71 = -d71;
                }
                if (d72 < 0.0) {
                    d72 = -d72;
                }
                double d73 = d69 * this.iUA + d70 * this.iUB;
                double d74 = d69 * this.iVA + d70 * this.iVB;
                if (d73 < 0.0) {
                    d73 = -d73;
                }
                if (d74 < 0.0) {
                    d74 = -d74;
                }
                this.currentTextureLevel += this.compiledFace.c * 2.0;
                this.dpDivZ = this.currentTextureLevel * ((d73 *= (double)texture.width) + (d74 *= (double)texture.height)) / (d71 + d72);
                this.incUDivZ = this.iUA * this.iZoomX;
                this.incVDivZ = this.iVA * this.iZoomX;
            }
        }
        this.drawFace3DPixels();
    }

    private final void drawFace3DPixels() {
        do {
            int n = (this.renderPixelHeight - this.YBF - 1) * this.renderPixelWidth;
            int n2 = this.YBF * this.renderPixelWidth;
            int n3 = this.XBF;
            this.startXY = n + n3;
            int n4 = n2 + n3;
            int n5 = this.zBuffer[n4];
            int n6 = n5 >> 16 & 0xFF;
            n5 &= 0xFFFF;
            double d = ((double)this.YBF - this.renderPixelHeightDiv2) * this.iZoomY;
            double d2 = d * this.iZB + this.iZC;
            double d3 = d2 - this.renderPixelWidthDiv2 * this.iZA * this.iZoomX;
            double d4 = this.iZA * this.iZoomX;
            double d5 = d * this.iUBB + this.iUBC;
            double d6 = d * this.iVBB + this.iVBC;
            double d7 = d * this.iWBB + this.iWBC;
            double d8 = d * this.iUB + this.iUC;
            double d9 = d * this.iVB + this.iVC;
            while (n3 < n5) {
                double d10;
                double d11;
                double d12;
                double d13;
                double d14;
                double d15;
                double d16;
                double d17;
                int n7 = n5;
                int n8 = n3;
                double d18 = n7 - n8;
                double d19 = (double)n8 - this.renderPixelWidthDiv2;
                double d20 = (double)n7 - this.renderPixelWidthDiv2;
                d20 *= this.iZoomX;
                double d21 = (d19 *= this.iZoomX) * this.iZA + d2;
                double d22 = d21 + d18 * d4;
                double d23 = 1.0 / d21;
                double d24 = 1.0 / d22;
                double d25 = d21;
                double d26 = d22;
                double d27 = d23;
                double d28 = d24;
                if (d23 > d24) {
                    d17 = d23;
                    d23 = d24;
                    d24 = d17;
                }
                if (d23 != d24 && d18 > 8.0 && d23 * 4.0 < d24) {
                    if (d4 > 0.0) {
                        d23 = 0.25 * d27;
                        d28 = 0.25 * d27;
                        d26 = 4.0 * d25;
                    } else {
                        d24 = 4.0 * d27;
                        d28 = 4.0 * d27;
                        d26 = 0.25 * d25;
                    }
                    int n9 = n8 + (int)((d26 - d25) / d4);
                    if (n9 - n7 > 8) {
                        if (n9 > n7) {
                            n9 = n7;
                        }
                        n7 = n9;
                    } else {
                        n7 = n8 + 8;
                    }
                    d18 = n7 - n8;
                    d26 = d25 + d4 * d18;
                    d28 = 1.0 / d26;
                }
                d17 = 1.0 / d18;
                if (d18 <= 2.0) {
                    // empty if block
                }
                n3 = n7;
                int n10 = n + n7;
                double d29 = d24 * 0.1;
                double d30 = 2.147483648E9 * d29;
                this.iZi = (int)(d21 * d30);
                this.incIzi = (int)(d4 * d30);
                this.scaleZ = (int)(2.147483648E9 / d29);
                this.uniformIz = 0;
                this.incUniformIz = (int)(d26 * d17 * d30);
                if ((this.faceRenderMode & 1) != 0) {
                    d16 = d19 * this.iWBA + d7;
                    d15 = d19 * this.iUBA + d5;
                    d14 = d19 * this.iVBA + d6;
                    d13 = d16 * d27;
                    d12 = (d16 + this.incWBDivZ * d18) * d28;
                    d12 -= (double)((int)d13);
                    d13 -= (double)((int)d13);
                    this.ofsWB = (int)(d13 * 2.147483648E9);
                    this.sizeWB = (int)((d12 - d13) * 65536.0);
                    d11 = d15 * d27;
                    d10 = (d15 + this.incUBDivZ * d18) * d28;
                    d10 -= (double)((int)d11);
                    d11 -= (double)((int)d11);
                    this.ofsUB = (int)(d11 * 2.147483648E9);
                    this.sizeUB = (int)((d10 - d11) * 65536.0);
                    double d31 = d14 * d27;
                    double d32 = (d14 + this.incVBDivZ * d18) * d28;
                    d32 -= (double)((int)d31);
                    d31 -= (double)((int)d31);
                    this.ofsVB = (int)(d31 * 2.147483648E9);
                    this.sizeVB = (int)((d32 - d31) * 65536.0);
                }
                if ((this.faceRenderMode & 4) != 0 || (this.faceRenderMode & 0x80) != 0) {
                    d16 = d19 * this.iUA + d8;
                    d15 = d16 * d27;
                    d14 = (d16 + this.incUDivZ * d18) * d28;
                    d14 -= (double)((int)d15);
                    d15 -= (double)((int)d15);
                    this.ofsU = (int)(d15 * 2.147483648E9);
                    this.sizeU = (int)((d14 - d15) * 65536.0);
                    d13 = d19 * this.iVA + d9;
                    d12 = d13 * d27;
                    d11 = (d13 + this.incVDivZ * d18) * d28;
                    d11 -= (double)((int)d12);
                    d12 -= (double)((int)d12);
                    this.ofsV = (int)(d12 * 2.147483648E9);
                    this.sizeV = (int)((d11 - d12) * 65536.0);
                    d10 = this.dpDivZ * d27;
                    this.numMipMap = 0;
                    int n11 = (int)d10;
                    if (n11 >= 0) {
                        this.numMipMap = n11 < log2.length ? log2[n11] : 32;
                    }
                }
                while (this.startXY < n10) {
                    this.endXY = n10;
                    if ((this.faceRenderMode & 4) != 0 || (this.faceRenderMode & 0x80) != 0) {
                        if (this.numMipMap < 0) {
                            this.numMipMap = 0;
                        }
                        if ((this.faceRenderMode & 0x80) != 0) {
                            this.normalPixels = this.bTexturePixels;
                            this.decalWidth = this.bdecalWidth;
                            this.decalHeight = this.bdecalHeight;
                            this.maskHeight = this.bmaskHeight;
                            this.maskWidth = this.bmaskWidth;
                            this.largeurImage = this.bLargeurImage;
                            this.hauteurImage = this.bHauteurImage;
                        }
                        if ((this.faceRenderMode & 4) != 0) {
                            this.texturePixels = this.dTexturePixels;
                            this.decalWidth = this.ddecalWidth;
                            this.decalHeight = this.ddecalHeight;
                            this.maskHeight = this.dmaskHeight;
                            this.maskWidth = this.dmaskWidth;
                            this.largeurImage = this.dLargeurImage;
                            this.hauteurImage = this.dHauteurImage;
                        }
                        this.endXMipMap = n7;
                        if (this.numMipMap >= 1) {
                            if (this.numMipMap > this.dNbMipMap) {
                                this.numMipMap = this.dNbMipMap;
                            }
                            if (this.dNbMipMap > 0 && this.dMipMap[this.numMipMap - 1] != null) {
                                this.texturePixels = this.dMipMap[this.numMipMap - 1];
                                this.decalWidth -= this.numMipMap;
                                this.decalHeight -= this.numMipMap;
                                this.maskWidth >>= this.numMipMap;
                                this.maskHeight >>= this.numMipMap;
                                this.largeurImage >>= this.numMipMap;
                                this.hauteurImage >>= this.numMipMap;
                                if (this.normalPixels != null) {
                                    this.normalPixels = this.bMipMap[this.numMipMap - 1];
                                }
                            }
                        }
                        int n12 = this.numMipMap;
                        if (this.numMipMap >= this.dNbMipMap) {
                            this.numMipMap = this.dNbMipMap;
                        }
                        if (d4 != 0.0) {
                            n12 = d21 < d22 ? this.numMipMap : this.numMipMap + 1;
                            double d33 = 1 << n12;
                            double d34 = this.dpDivZ / d33;
                            double d35 = (d34 - d3) / d4;
                            this.endXMipMap = (int)d35 + 1;
                        } else {
                            this.endXMipMap = n7;
                        }
                        this.numMipMap = d21 < d22 ? --this.numMipMap : ++this.numMipMap;
                        this.decU = 31 - this.decalWidth;
                        this.decV = 31 - this.decalHeight;
                        this.maskHeight <<= this.decalWidth;
                        this.decV -= this.decalWidth;
                        this.maskUV = this.maskHeight | this.maskWidth;
                        this.decUBX = this.decU - 8;
                        this.decVBX = this.decV + this.decalWidth - 8;
                        int n13 = n + this.endXMipMap;
                        if (n13 <= this.startXY) {
                            n13 = n10;
                        }
                        if (n13 > n10) {
                            n13 = n10;
                        }
                        if (this.maskWidth == 0) {
                            this.startXY = n13;
                        }
                        this.endXY = n13;
                    }
                    this.drawPixelsFull();
                }
            }
            if (this.XBF <= 0 || (this.antialias & 1) == 0) continue;
            this.softBuffer[this.nbSoftPoint] = n + this.XBF;
            this.softBufferR[this.nbSoftPoint++] = n6;
        } while (this.nextSegment());
    }

    private final int bilinUV(int n, int n2, int n3, int n4) {
        int n5 = ((n & 0xFF00FF) * this.f13 + (n2 & 0xFF00FF) * this.f23 + (n3 & 0xFF00FF) * this.f14 + (n4 & 0xFF00FF) * this.f24 & 0xFF00FF00 | (n & 0xFF00) * this.f13 + (n2 & 0xFF00) * this.f23 + (n3 & 0xFF00) * this.f14 + (n4 & 0xFF00) * this.f24 & 0xFF0000) >> 8;
        return n5;
    }

    private final void computeTexture() {
        int n = this.uniIz * this.sizeU + this.ofsU;
        int n2 = this.uniIz * this.sizeV + this.ofsV;
        int n3 = n >> this.decU & this.maskWidth;
        int n4 = n2 >> this.decV & this.maskHeight;
        int n5 = n4 | n3;
        int n6 = n3 + 1 & this.maskWidth | n4;
        int n7 = n4 + this.largeurImage & this.maskHeight | n3;
        int n8 = n3 + 1 & this.maskWidth | n4 + this.largeurImage & this.maskHeight;
        int n9 = n >> this.decUBX & 0xFF;
        int n10 = n2 >> this.decVBX & 0xFF;
        this.f24 = n9 * n10 >> 8;
        this.f23 = n9 - this.f24;
        this.f14 = n10 - this.f24;
        this.f13 = (n9 ^ 0xFF) * (n10 ^ 0xFF) >> 8;
        if (this.useNormalTexture) {
            this.rNormalTexel = this.bilinUV(this.normalPixels[n5], this.normalPixels[n6], this.normalPixels[n7], this.normalPixels[n8]);
        }
        if (this.useDiffuseTexture) {
            this.pixelColor = this.rDiffuseTexel = this.bilinUV(this.texturePixels[n5], this.texturePixels[n6], this.texturePixels[n7], this.texturePixels[n8]);
        }
    }

    private int clip(int n) {
        if (n >= 1023) {
            return 1023;
        }
        if (n <= -1023) {
            return -1023;
        }
        return n;
    }

    private final void computeLight() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.uniIz * this.sizeWB + this.ofsWB >> 20;
        int n6 = this.uniIz * this.sizeUB + this.ofsUB >> 20;
        int n7 = this.uniIz * this.sizeVB + this.ofsVB >> 20;
        int n8 = n4 = normalMap[n6 * n6 + n7 * n7 + n5 * n5 >>> 10];
        if (this.useNormalTexture) {
            n3 = ((this.rNormalTexel & 0xFF0000) >>> 16) - 128;
            n2 = ((this.rNormalTexel & 0xFF00) >>> 8) - 128;
            n = (this.rNormalTexel & 0xFF) - 128;
            n4 = (n3 * n6 + n2 * n7 + n * n5) * (n4 >>> 7) >> 14;
        } else {
            n4 = n5 * (n4 >>> 7) >> 7;
        }
        n3 = n4 & 0xFF;
        n2 = 256 - n3;
        n4 >>= 8;
        n = this.specularLightMap[n4 += 1024];
        int n9 = this.specularLightMap[n4 + 1];
        this.rSpecularColor = ((n & 0xFF00FF) * n2 + (n9 & 0xFF00FF) * n3 & 0xFF00FF00 | (n & 0xFF00) * n2 + (n9 & 0xFF00) * n3 & 0xFF0000) >>> 8;
        this.rDiffuseLight = (n >>> 24) * n2 + (n9 >>> 24) * n3 >>> 8;
        if (this.useEnvironmentTexure) {
            int n10 = -n6 * n8 >> 16;
            int n11 = n7 * n8 >> 16;
            int n12 = n10 & 0xFF;
            int n13 = n11 & 0xFF;
            this.f24 = n12 * n13 >> 8;
            this.f23 = n12 - this.f24;
            this.f14 = n13 - this.f24;
            this.f13 = (n12 ^ 0xFF) * (n13 ^ 0xFF) >> 8;
            n10 >>= 8;
            n11 >>= 8;
            int n14 = ((n11 += 128) << 8 | (n10 += 128)) & 0xFFFF;
            int n15 = n14 + 1 & 0xFFFF;
            int n16 = n14 + 256 & 0xFFFF;
            int n17 = n16 + 1 & 0xFFFF;
            this.rSpecularColor = this.eTexturePixels[(n11 & this.emaskHeight) << this.edecalWidth | n10 & this.emaskWidth];
            this.rDiffuseLight = 0;
        }
    }

    private final void drawPixelsFull() {
        this.rDiffuseLight = 255;
        this.rSpecularColor = 0;
        this.pixelColor = this.rDiffuseTexel;
        try {
            this.useEnvironmentTexure = (this.faceRenderMode & 0x100) != 0;
            this.useDiffuseTexture = (this.faceRenderMode & 4) != 0;
            this.useNormalTexture = (this.faceRenderMode & 0x80) != 0;
            boolean bl = this.useDiffuseTexture || this.useNormalTexture;
            boolean bl2 = (this.faceRenderMode & 1) != 0;
            boolean bl3 = this.alphaLevel != 0;
            boolean bl4 = false;
            if (bl) {
                if (bl2) {
                    while (this.startXY < this.endXY) {
                        this.rZ = iZ[this.iZi >>> 16];
                        this.iZi += this.incIzi;
                        this.uniIz = (this.uniformIz >>> 16) * this.rZ >>> 16;
                        this.uniformIz += this.incUniformIz;
                        this.computeTexture();
                        this.computeLight();
                        int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                        this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                        this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                        this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                    }
                } else {
                    while (this.startXY < this.endXY) {
                        this.rZ = iZ[this.iZi >>> 16];
                        this.iZi += this.incIzi;
                        this.uniIz = (this.uniformIz >>> 16) * this.rZ >>> 16;
                        this.uniformIz += this.incUniformIz;
                        this.computeTexture();
                        int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                        this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                        this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                        this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                    }
                }
            } else if (bl2) {
                while (this.startXY < this.endXY) {
                    this.rZ = iZ[this.iZi >>> 16];
                    this.iZi += this.incIzi;
                    this.uniIz = (this.uniformIz >>> 16) * this.rZ >>> 16;
                    this.uniformIz += this.incUniformIz;
                    this.computeLight();
                    int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                    this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                    this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                    this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                }
            } else {
                while (this.startXY < this.endXY) {
                    this.rZ = iZ[this.iZi >>> 16];
                    this.iZi += this.incIzi;
                    this.uniIz = (this.uniformIz >> 16) * this.rZ >>> 16;
                    this.uniformIz += this.incUniformIz;
                    int n = ((this.rDiffuseTexel & 0xFF00FF) * this.rDiffuseLight & 0xFF00FF00 | (this.rDiffuseTexel & 0xFF00) * this.rDiffuseLight & 0xFF0000) >> 8 & 0xFEFEFE;
                    this.pixelColor = n + (this.rSpecularColor & 0xFEFEFE);
                    this.pixelColor |= (this.pixelColor >> 8 & 0x10101) * 255;
                    this.rPixels[this.startXY++] = this.pixelColor | 0xFF000000;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            Log.log(arrayIndexOutOfBoundsException);
        }
        catch (NullPointerException nullPointerException) {
            Log.log(nullPointerException);
        }
        this.startXY = this.endXY;
    }

    public final void antialiasPixels() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        for (n6 = 0; n6 < this.nbDebug; ++n6) {
            this.pixels[this.debug[n6]] = 0x880000;
        }
        this.nbDebug = 0;
        if ((this.antialias & 1) != 0) {
            for (n6 = 0; n6 < this.nbSoftPoint; ++n6) {
                n5 = this.softBuffer[n6];
                n4 = this.rPixels[n5 - 1];
                n3 = this.rPixels[n5];
                n2 = 1 + this.softBufferR[n6];
                n4 = ((n4 & 0xFF00FF) * n2 & 0xFF00FF00 | (n4 & 0xFF00) * n2 & 0xFF0000) >>> 8;
                n2 = 256 - n2;
                n3 = ((n3 & 0xFF00FF) * n2 & 0xFF00FF00 | (n3 & 0xFF00) * n2 & 0xFF0000) >>> 8;
                this.softBufferR[n6] = n = (n4 & 0xFEFEFE) + (n3 & 0xFEFEFE);
            }
            for (n6 = 0; n6 < this.nbSoftPoint; ++n6) {
                n5 = this.softBuffer[n6];
                this.rPixels[n5] = this.softBufferR[n6];
            }
        }
        if (this.antialias > 1) {
            n6 = this.antialias & 0xFE;
            switch (n6) {
                case 2: {
                    for (n5 = 0; n5 < this.renderPixelHeight; ++n5) {
                        n2 = n4 + (this.renderPixelWidth >> 1);
                        n = n4 << 1;
                        for (n3 = n4 = n5 * (this.renderPixelWidth >> 1); n3 < n2; ++n3) {
                            int n7 = this.rPixels[n] & 0xFEFEFE;
                            int n8 = this.rPixels[n + 1] & 0xFEFEFE;
                            this.pixels[n3] = n7 + n8 >> 1;
                            n += 2;
                        }
                    }
                    break;
                }
                case 4: {
                    for (n5 = 0; n5 < this.renderPixelHeight >> 1; ++n5) {
                        n2 = n4 + this.renderPixelWidth;
                        n = n4 << 1;
                        for (n3 = n4 = n5 * this.renderPixelWidth; n3 < n2; ++n3) {
                            int n9;
                            int n10 = this.rPixels[n] & 0xFEFEFE;
                            int n11 = this.rPixels[n + this.renderPixelWidth] & 0xFEFEFE;
                            this.pixels[n3] = n9 = n10 + n11 >> 1;
                            ++n;
                        }
                    }
                    break;
                }
                case 6: {
                    for (n5 = 0; n5 < this.renderPixelHeight >> 1; ++n5) {
                        n2 = n4 + (this.renderPixelWidth >> 1);
                        n = n4 << 2;
                        for (n3 = n4 = n5 * (this.renderPixelWidth >> 1); n3 < n2; ++n3) {
                            int n12 = this.rPixels[n];
                            int n13 = this.rPixels[n + 1];
                            int n14 = this.rPixels[n + this.renderPixelWidth];
                            int n15 = this.rPixels[n + this.renderPixelWidth + 1];
                            int n16 = (n12 & 0xFF00FF) + (n13 & 0xFF00FF) + (n14 & 0xFF00FF) + (n15 & 0xFF00FF) >> 2 & 0xFF00FF;
                            int n17 = (n12 & 0xFF00) + (n13 & 0xFF00) + (n14 & 0xFF00) + (n15 & 0xFF00) >> 2 & 0xFF00;
                            this.pixels[n3] = n16 | n17;
                            n += 2;
                        }
                    }
                    break;
                }
            }
        }
    }

    private final void initPixelsBuffer(int n, int n2) {
        Object object;
        Log.log("Drawer.initPixelsBuffer()");
        this.useMIS = true;
        try {
            object = Class.forName("java.awt.image.BufferedImage");
            PixelsBufferBI pixelsBufferBI = new PixelsBufferBI(n, n2);
            this.image = pixelsBufferBI.getImage();
            this.pixels = pixelsBufferBI.getPixels();
            this.useMIS = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.useMIS) {
            this.pixels = new int[n * n2];
            object = new DirectColorModel(24, 0xFF0000, 65280, 255);
            this.imageMemoire = new MemoryImageSource(n, n2, (ColorModel)object, this.pixels, 0, n);
            this.imageMemoire.setAnimated(true);
            this.imageMemoire.setFullBufferUpdates(false);
            this.image = Toolkit.getDefaultToolkit().createImage(this.imageMemoire);
            this.useMIS = true;
        }
    }

    public final void drawPixelsOnCanvas(Canvas canvas) {
        Graphics graphics = canvas.getGraphics();
        if (this.useMIS) {
            this.imageMemoire.newPixels();
        }
        if (graphics != null) {
            ((Render2D.PCanvas)canvas).image = this.image;
            canvas.update(graphics);
        }
    }

    static {
        int n;
        iZ = new int[65536];
        log2 = new int[2048];
        normalMap = new int[65536];
        for (n = 0; n < log2.length; ++n) {
            Drawer.log2[n] = (int)(Math.log(n) / 0.6931471805599453);
        }
        for (n = 0; n < iZ.length; ++n) {
            Drawer.iZ[n] = (int)(2.147483648E9 / ((double)n + 1.0E-9));
        }
        Drawer.normalMap[0] = 1;
        for (n = 0; n < normalMap.length; ++n) {
            Drawer.normalMap[n] = (int)(2.147483648E9 / Math.sqrt(((double)n + 1.0E-9) * 1024.0));
        }
    }
}

