/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.utils;

import java.io.PrintStream;
import java.util.Date;

public class Log {
    private static PrintStream logout = System.out;
    private static boolean debug = false;
    private static boolean enabled = true;
    private static boolean showAll = true;
    private static String[] debugClasses = null;
    private static int debugClassIndex = 0;

    public static void setOutputStream(PrintStream printStream) {
        logout = printStream;
    }

    public static void setPrintDebug(boolean bl) {
        debug = bl;
    }

    public static void showAll(boolean bl) {
        showAll = bl;
    }

    public static void addDebugClass(Class clazz) {
        if (debugClasses == null) {
            debugClasses = new String[100];
        }
        if (Log.isMonitored(clazz)) {
            if (debug) {
                logout.println("Class " + clazz.toString() + " is already tagged for debug info");
            }
            return;
        }
        if (debugClassIndex > debugClasses.length) {
            String[] stringArray = new String[debugClasses.length];
            System.arraycopy(debugClasses, 0, stringArray, 0, debugClasses.length);
            debugClasses = new String[debugClasses.length + 100];
            System.arraycopy(stringArray, 0, debugClasses, 0, stringArray.length);
        }
        Log.debugClasses[Log.debugClassIndex++] = clazz.toString();
    }

    public static void enable(boolean bl) {
        enabled = bl;
    }

    public static synchronized void log(String string) {
        logout.println(string);
    }

    public static synchronized void log(Throwable throwable) {
        throwable.printStackTrace(logout);
    }

    private static synchronized void log(Object object, Throwable throwable) {
        Log.log(object.getClass(), throwable);
    }

    public static synchronized void log(Object object, String string) {
        Log.log(object.getClass(), string);
    }

    private static synchronized void log(Class clazz, Throwable throwable) {
        if (clazz == null) {
            System.err.println("Cannot log event, calling class missing: ");
            throwable.printStackTrace();
        } else if (showAll || Log.isMonitored(clazz)) {
            if (debug) {
                System.err.println(new Date(System.currentTimeMillis()) + " - " + clazz.getPackage().getName() + "." + clazz.getName() + ": ");
                throwable.printStackTrace();
            }
            if (logout != null && enabled) {
                throwable.printStackTrace(logout);
            }
        }
    }

    public static synchronized void log(Class clazz, Exception exception) {
        if (clazz == null) {
            System.err.println("Cannot log event, calling class missing: ");
            exception.printStackTrace();
        } else if (showAll || Log.isMonitored(clazz)) {
            if (debug) {
                System.err.println(new Date(System.currentTimeMillis()) + " - " + clazz.getPackage().getName() + "." + clazz.getName() + ": ");
                exception.printStackTrace();
            }
            if (logout != null && enabled) {
                exception.printStackTrace(logout);
            }
        }
    }

    private static synchronized void log(Class clazz, String string) {
        if (clazz == null) {
            System.err.println("Cannot log message, calling class missing: ");
        } else if (showAll || Log.isMonitored(clazz)) {
            if (debug) {
                System.err.println(new Date(System.currentTimeMillis()) + " - " + clazz.getPackage().getName() + "." + clazz.getName() + ": ");
                System.err.println(string);
            }
            if (logout != null && enabled) {
                logout.println(string);
            }
        }
    }

    private static boolean isMonitored(Class clazz) {
        if (debugClasses == null) {
            return false;
        }
        for (int i = 0; i < debugClasses.length; ++i) {
            if (debugClasses[i] != clazz.toString()) continue;
            return true;
        }
        return false;
    }

    public static synchronized void log(Exception exception) {
        exception.printStackTrace(logout);
    }
}

