/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.utils.io;

import java.io.IOException;
import net.dzzd.utils.Log;
import net.dzzd.utils.io.IOManager;

public class IOManagerAsynch
implements Runnable {
    private volatile byte[] data;
    private volatile String dataSource;
    private volatile boolean loading;
    private volatile boolean loadingError;
    private volatile Thread thread;

    public IOManagerAsynch downloadData(String string) throws IOException {
        if (this.isLoading()) {
            throw new IOException("IOManagerAsynch is already loading another ressource");
        }
        this.dataSource = string;
        this.data = null;
        this.loadingError = false;
        this.loading = true;
        this.thread = new Thread((Runnable)this, "3DZZD ASYNCH DATA LOADER");
        this.thread.start();
        return this;
    }

    public void run() {
        try {
            this.data = IOManager.downloadData(this.dataSource);
        }
        catch (IOException iOException) {
            Log.log(iOException);
            this.loadingError = true;
        }
        this.loading = false;
        this.thread = null;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public boolean isLoading() {
        return this.thread != null || this.loading;
    }

    public boolean isLoadingError() {
        return this.loadingError;
    }

    public byte[] getData() {
        return this.data;
    }
}

