/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.net.MalformedURLException;
import java.net.URL;
import net.dzzd.access.IURLTexture;
import net.dzzd.core.Texture;
import net.dzzd.utils.Log;

public final class URLTexture
extends Texture
implements ImageObserver,
IURLTexture,
Runnable {
    String baseURL = null;
    String sourceFile = null;
    private Image imageLoad;
    private boolean reload = true;

    public void build() {
        if (this.reload) {
            this.load();
        } else {
            super.build();
        }
    }

    public void run() {
        if (this.sourceFile == null) {
            return;
        }
        if (this.baseURL == null) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        try {
            this.imageLoad = toolkit.getImage(new URL(this.baseURL + this.sourceFile.replace(' ', '+')));
        }
        catch (MalformedURLException malformedURLException) {
            Log.log(malformedURLException);
            this.endLoading(true);
            return;
        }
        if (this.imageLoad == null) {
            this.endLoading(true);
            return;
        }
        if (toolkit.prepareImage(this.imageLoad, -1, -1, this)) {
            this.endLoading(false);
            return;
        }
        int n = 0;
        do {
            try {
                Thread.sleep(10L);
                Thread.yield();
            }
            catch (InterruptedException interruptedException) {
                this.endLoading(false);
            }
        } while (((n = toolkit.checkImage(this.imageLoad, -1, -1, this)) & 0xE0) == 0);
        if ((n & 0x20) != 0) {
            this.endLoading(false);
        } else {
            this.endLoading(true);
        }
    }

    void endLoading(boolean bl) {
        if (!bl) {
            this.imageToTexturePixels();
            this.setError(false);
            this.setFinished(true);
            this.build();
            return;
        }
        this.setError(true);
        this.setFinished(true);
        Log.log("Loading error (" + this.baseURL + this.sourceFile + ")");
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 3: {
                this.setMaximumProgress(n4 * n5);
                return true;
            }
            case 8: {
                this.setProgress(n2 + n3 * n4);
                return true;
            }
            case 4: {
                return true;
            }
            case 16: {
                return false;
            }
            case 32: {
                this.setProgress(this.getMaximumProgress());
                return false;
            }
            case 64: {
                return false;
            }
            case 128: {
                return false;
            }
        }
        return false;
    }

    void prepareTextureSize() {
        this.largeur = this.imageLoad.getWidth(null);
        this.hauteur = this.imageLoad.getHeight(null);
        this.maskLargeur = 1;
        this.decalLargeur = 0;
        this.largeurImage = 1;
        while (this.largeurImage < this.largeur) {
            this.largeurImage <<= 1;
            ++this.decalLargeur;
        }
        this.maskLargeur = this.largeurImage - 1;
        this.maskHauteur = 1;
        this.decalHauteur = 0;
        this.hauteurImage = 1;
        while (this.hauteurImage < this.hauteur) {
            this.hauteurImage <<= 1;
            ++this.decalHauteur;
        }
        this.maskHauteur = this.hauteurImage - 1;
        if (this.largeur != this.largeurImage || this.hauteur != this.hauteurImage) {
            Image image;
            this.imageLoad = image = this.imageLoad.getScaledInstance(this.largeurImage, this.hauteurImage, 4);
            this.largeur = this.largeurImage;
            this.hauteur = this.hauteurImage;
        }
    }

    void imageToTexturePixels() {
        this.prepareTextureSize();
        this.pixels = new int[this.largeurImage * this.hauteurImage];
        PixelGrabber pixelGrabber = new PixelGrabber(this.imageLoad, 0, 0, this.largeur, this.hauteur, this.pixels, 0, this.largeurImage);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.imageLoad = null;
        System.gc();
    }

    public void setSourceFile(String string) {
        this.reload = true;
        this.sourceFile = string;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public void setBaseURL(String string) {
        this.reload = true;
        this.baseURL = string;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void load(String string, String string2) {
        this.baseURL = string;
        this.sourceFile = string2;
        this.load();
    }

    public void load(String string, String string2, boolean bl) {
        this.baseURL = string;
        this.sourceFile = string2;
        this.load();
    }

    public void load() {
        this.reset();
        this.setAction(0);
        this.reload = false;
        Thread thread = new Thread(this);
        thread.start();
    }
}

