/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute.annotation;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.ElementValueVisitor;
import proguard.classfile.visitor.ClassFileVisitor;

public class ClassElementValue
extends ElementValue {
    protected static final int CONSTANT_FIELD_SIZE = 3;
    public int u2classInfoIndex;
    public ClassFile[] referencedClassFiles;

    protected ClassElementValue() {
    }

    public void referencedClassesAccept(ClassFileVisitor classFileVisitor) {
        if (this.referencedClassFiles != null) {
            for (int i = 0; i < this.referencedClassFiles.length; ++i) {
                ClassFile classFile = this.referencedClassFiles[i];
                if (classFile == null) continue;
                classFile.accept(classFileVisitor);
            }
        }
    }

    protected int getLength() {
        return 3;
    }

    protected void readInfo(DataInput dataInput) throws IOException {
        this.u2classInfoIndex = dataInput.readUnsignedShort();
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2classInfoIndex);
    }

    public void accept(ClassFile classFile, Annotation annotation, ElementValueVisitor elementValueVisitor) {
        elementValueVisitor.visitClassElementValue(classFile, annotation, this);
    }
}

