/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/

package net.dzzd.access;

/** 
 *  Used for accessing to a Mesh3DCollisionGenerator.
 *  <br>
 *  IMesh3DCollisionGenerator are able to generate a subset of Face3D as a Face3DList to test for collisions on a Mesh3D.
 *  
 *  @author Bruno Augier
 *  @version 1.0, 01/01/04
 *  @since 1.0
 *	@see IMesh3D
 */
public interface IMesh3DCollisionGenerator
{
	/**
	 * Generate a (LOD) Face3DList potentialy hitted for a SolidSphere3D collision test.
	 * <br>
	 * Collision values must be given in object space
	 * <br>
	 * 
	 * @param x collision start point x in object space
	 * @param y collision start point y in object space
	 * @param z collision start point z in object space
	 * @param tx collision end point x in object space
	 * @param ty collision end point y in object space
	 * @param tz collision end point z in object space
	 * @param radius radius for collision
	 */		
	public void generateForSolidSphere3DCollision(double x,double y,double z,double tx,double ty,double tz,double radius);

	/**
	 * Gets number of Face3D generated by the last call to any generateXXX() method.
	 * <br>
	 * @return number of Face3D that was generated for last call to any generateXXX() method
	 */		
	public int getNbCollisionFaces();
	
	/**
	 * Gets Face3DList generated by the last call to any generateXXX() method.
	 * <br>
	 * @return Face3DList that was generated for last call to any generateXXX() method
	 */	
	public IFace3DList getCollisionFace3DList();
}