/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/

package net.dzzd.core;

import net.dzzd.access.*;


public class Scene2D extends Scene implements IScene2D
{	
	public static final long serialVersionUID = 0x00000001;		
	private int maxObject2D;
	
	public Scene2D()
	{
		super();
		this.setScene2DBufferSize(1024);	
		this.clearScene2D();
	}	
	
	public void setScene2DBufferSize(int maxObject2D)
	{
		//TODO: SET object 2d buffer size
		this.clearScene2D();
	}	
	
    public int getNbScene2DObject()
	{
		//TODO: count object2d
		return 0;
		
	}
	
	public void clearScene2D()
	{

	}	
	
	public void addScene2DObject(IScene2DObject object)
	{

	}	

	public void addScene2DObjects(IScene2DObject objects[])
	{
		for(int x=0;x<objects.length;x++)
			this.addScene2DObject(objects[x]);
	}
	
	public void removeScene2DObject(IScene2DObject object)
	{
		if(object==null)
			return;
		
		//TODO: remove object from scene
					
	}

}