/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/

package net.dzzd.core;

import net.dzzd.access.*;

import java.util.*;
import java.io.Serializable;
import net.dzzd.utils.Log;

public class SceneObject extends MonitoredSceneObject implements ISceneObject,Serializable
{
	public static final long serialVersionUID = 0x00000001;
    IScene scene;
	
    String nom;
    int id;
    
	private Hashtable properties;
	transient private Integer build;
	//transient private Integer build;

	SceneObject()
	{
       this.scene=null;
       this.nom = null;
       this.id = -1;
	   this.properties=new Hashtable();
	   this.build=new Integer(-1);
	   //this.buildInteger=new Integer();
	   this.setProgress(100);
	   this.setFinished(true);
	   this.setError(false);
	}

	public String getName()
	{
		return this.nom;
	}
	
	public void setName(String name)
	{
		this.nom=name;
	}

	public int getId()
	{
		return this.id;
	}
	
	public void setId(int id)
	{
		this.id=id;
	}

	public IScene getScene()
	{
		return this.scene;
	}
	
	public void setScene(IScene scene)
	{
		this.scene=scene;
	}
	
	public void setProperty(String key,Object value)
	{
		if(value==null)
			this.properties.remove(key);
		else
			this.properties.put(key,value);
	}
	
	public Object getProperty(String key)
	{
		return this.properties.get(key);
	}	
	
	public void clearProperties()
	{
		this.properties=new Hashtable();
	}
	
	public void build()
	{
		this.build=new Integer(this.getBuild()+1);
		//Log.log("SceneObject.build() ("+ this.build +") : " + this.nom);
	}
	
	public Integer getBuildAsInteger()
	{
		return this.build;
	}	
	
	public int getBuild()
	{
		return this.build.intValue();
	}
	
	public void setBuild(int build)
	{
		this.build=new Integer(build);
	}	
	
	public void copy(ISceneObject source)
	{
			super.copy(source);
			this.setName(source.getName());
	}
	
}