/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassFile;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.visitor.ClassFileVisitor;

public class ConcreteClassFileDownTraveler
implements ClassFileVisitor {
    private ClassFileVisitor classFileVisitor;

    public ConcreteClassFileDownTraveler(ClassFileVisitor classFileVisitor) {
        this.classFileVisitor = classFileVisitor;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        if ((programClassFile.getAccessFlags() & 0x600) != 0) {
            ClassFile[] classFileArray = programClassFile.subClasses;
            if (classFileArray != null) {
                for (int i = 0; i < classFileArray.length; ++i) {
                    classFileArray[i].accept(this);
                }
            }
        } else {
            programClassFile.accept(this.classFileVisitor);
        }
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        if ((libraryClassFile.getAccessFlags() & 0x600) != 0) {
            ClassFile[] classFileArray = libraryClassFile.subClasses;
            if (classFileArray != null) {
                for (int i = 0; i < classFileArray.length; ++i) {
                    classFileArray[i].accept(this);
                }
            }
        } else {
            libraryClassFile.accept(this.classFileVisitor);
        }
    }
}

