/*
 * Decompiled with CFR 0.152.
 */
package proguard.util;

import java.util.ArrayList;
import proguard.util.StringMatcher;

public class BasicMatcher
implements StringMatcher {
    private static final String SINGLE_CHARACTER_WILDCARD = "?";
    private static final String MULTIPLE_CHARACTERS_WILDCARD1 = "*";
    private static final String MULTIPLE_CHARACTERS_WILDCARD2 = "**";
    private static final String SPECIAL_CHARACTER_WILDCARD = "%";
    private String[] expressionParts;
    private char[] wildcardCharacters;
    private char[] extendedWildcardCharacters;
    private char[] specialWildcardCharacters;

    public BasicMatcher(String string) {
        this(string, null, null, null);
    }

    public BasicMatcher(String string, char[] cArray, char[] cArray2, char[] cArray3) {
        this.wildcardCharacters = cArray;
        this.extendedWildcardCharacters = cArray2;
        this.specialWildcardCharacters = cArray3;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            String string3 = string.regionMatches(n2, MULTIPLE_CHARACTERS_WILDCARD2, 0, MULTIPLE_CHARACTERS_WILDCARD2.length()) ? MULTIPLE_CHARACTERS_WILDCARD2 : (string.regionMatches(n2, MULTIPLE_CHARACTERS_WILDCARD1, 0, MULTIPLE_CHARACTERS_WILDCARD1.length()) ? MULTIPLE_CHARACTERS_WILDCARD1 : (string.regionMatches(n2, SINGLE_CHARACTER_WILDCARD, 0, SINGLE_CHARACTER_WILDCARD.length()) ? SINGLE_CHARACTER_WILDCARD : (string2 = string.regionMatches(n2, SPECIAL_CHARACTER_WILDCARD, 0, SINGLE_CHARACTER_WILDCARD.length()) ? SPECIAL_CHARACTER_WILDCARD : null)));
            if (string2 != null) {
                if (n < n2) {
                    arrayList.add(string.substring(n, n2));
                }
                arrayList.add(string2);
                n = n2 += string2.length();
                continue;
            }
            ++n2;
        }
        if (string2 == null) {
            arrayList.add(string.substring(n));
        }
        this.expressionParts = new String[arrayList.size()];
        arrayList.toArray(this.expressionParts);
    }

    public boolean matches(String string) {
        return this.matches(string, 0, 0);
    }

    private boolean matches(String string, int n, int n2) {
        if (n2 == this.expressionParts.length) {
            return n == string.length();
        }
        String string2 = this.expressionParts[n2];
        if (string2.equals(SINGLE_CHARACTER_WILDCARD)) {
            if (n == string.length()) {
                return false;
            }
            return this.matchesWildcard(string.charAt(n)) && this.matches(string, n + 1, n2 + 1);
        }
        if (string2.equals(MULTIPLE_CHARACTERS_WILDCARD1)) {
            for (int i = n; i <= string.length(); ++i) {
                if (i > n && !this.matchesWildcard(string.charAt(i - 1))) {
                    return false;
                }
                if (!this.matches(string, i, n2 + 1)) continue;
                return true;
            }
            return false;
        }
        if (string2.equals(MULTIPLE_CHARACTERS_WILDCARD2)) {
            for (int i = n; i <= string.length(); ++i) {
                if (i > n && !this.matchesExtendedWildcard(string.charAt(i - 1))) {
                    return false;
                }
                if (!this.matches(string, i, n2 + 1)) continue;
                return true;
            }
            return n == string.length();
        }
        if (string2.equals(SPECIAL_CHARACTER_WILDCARD)) {
            if (n == string.length()) {
                return false;
            }
            return this.matchesSpecialWildcard(string.charAt(n)) && this.matches(string, n + 1, n2 + 1);
        }
        int n3 = string2.length();
        return string.regionMatches(n, string2, 0, n3) && this.matches(string, n + n3, n2 + 1);
    }

    private boolean matchesWildcard(char c) {
        if (Character.isJavaIdentifierPart(c)) {
            return true;
        }
        if (this.wildcardCharacters != null) {
            for (int i = 0; i < this.wildcardCharacters.length; ++i) {
                if (c != this.wildcardCharacters[i]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesExtendedWildcard(char c) {
        if (this.matchesWildcard(c)) {
            return true;
        }
        if (this.extendedWildcardCharacters != null) {
            for (int i = 0; i < this.extendedWildcardCharacters.length; ++i) {
                if (c != this.extendedWildcardCharacters[i]) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesSpecialWildcard(char c) {
        if (this.specialWildcardCharacters != null) {
            for (int i = 0; i < this.specialWildcardCharacters.length; ++i) {
                if (c != this.specialWildcardCharacters[i]) continue;
                return true;
            }
        }
        return false;
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Regular expression [" + stringArray[0] + "]");
            BasicMatcher basicMatcher = new BasicMatcher(stringArray[0], null, new char[]{'/'}, null);
            for (int i = 1; i < stringArray.length; ++i) {
                String string = stringArray[i];
                System.out.print("String             [" + string + "]");
                System.out.println(" -> match = " + basicMatcher.matches(stringArray[i]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

