/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.IOException;
import java.io.InputStream;
import net.dzzd.access.IURLHeightMap;
import net.dzzd.utils.io.IOManager;

public class URLHeightMap
implements IURLHeightMap {
    private int[] hMap;
    private int hMapWidth;
    private int hMapHeight;

    public void load(String string, String string2, int n, int n2) {
        this.setWidth(n);
        this.setHeight(n2);
        this.hMap = new int[this.hMapWidth * this.hMapHeight];
        try {
            InputStream inputStream = IOManager.openStream(string + string2, true);
            for (int i = 0; i < this.hMap.length; ++i) {
                int n3 = inputStream.read();
                this.hMap[i] = 255 - n3;
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setWidth(int n) {
        this.hMapWidth = n;
    }

    public void setHeight(int n) {
        this.hMapHeight = n;
    }

    public double getAt(double d, double d2) {
        if (this.hMap == null) {
            return 0.0;
        }
        if (d < 0.0) {
            return 0.0;
        }
        if (d > 1.0) {
            return 0.0;
        }
        if (d2 < 0.0) {
            return 0.0;
        }
        if (d2 > 1.0) {
            return 0.0;
        }
        int n = (int)(d * 256.0 * (double)(this.hMapWidth - 1));
        int n2 = (int)(d2 * 256.0 * (double)(this.hMapHeight - 1));
        int n3 = n % 256;
        int n4 = 256 - n3;
        int n5 = n2 % 256;
        int n6 = 256 - n5;
        int n7 = this.hMap[(n >>= 8) + (n2 >>= 8) * this.hMapWidth];
        int n8 = this.hMap[(n + 1) % this.hMapWidth + n2 * this.hMapWidth];
        int n9 = this.hMap[n + (n2 + 1) % this.hMapHeight * this.hMapWidth];
        int n10 = this.hMap[(n + 1) % this.hMapWidth + (n2 + 1) % this.hMapHeight * this.hMapWidth];
        int n11 = n7 * n4 + n8 * n3;
        int n12 = n9 * n4 + n10 * n3;
        int n13 = (n11 >>= 8) * n6 + (n12 >>= 8) * n5;
        double d3 = (double)(n13 >>= 8) / 255.0;
        return d3;
    }
}

