/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.IFace3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IVertex3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Point3D;
import net.dzzd.core.Vertex3D;

public final class Face3D
implements IFace3D,
Serializable {
    Mesh3D object = null;
    int id;
    Vertex3D p0 = null;
    Vertex3D p1 = null;
    Vertex3D p2 = null;
    Point3D center = new Point3D();
    int smoothGroupMask = 0;
    float pa;
    float pb;
    float pc;
    float pd;
    float p0nx;
    float p0ny;
    float p0nz;
    float p1nx;
    float p1ny;
    float p1nz;
    float p2nx;
    float p2ny;
    float p2nz;
    float u0 = 0.0f;
    float u1 = 1.0f;
    float u2 = 1.0f;
    float v0 = 0.0f;
    float v1 = 0.0f;
    float v2 = 1.0f;
    Material material = null;
    float sphereBox;
    transient Face3D nextAlphaFace;

    public Face3D() {
    }

    public Face3D(IVertex3D iVertex3D, IVertex3D iVertex3D2, IVertex3D iVertex3D3) {
        this();
        this.p0 = (Vertex3D)iVertex3D;
        this.p1 = (Vertex3D)iVertex3D2;
        this.p2 = (Vertex3D)iVertex3D3;
    }

    Face3D setNormal() {
        Point3D point3D = new Point3D();
        Point3D point3D2 = new Point3D();
        point3D2.copy(this.p1);
        point3D.copy(this.p2);
        point3D2.sub(this.p0);
        point3D.sub(this.p0);
        point3D2.cross(point3D);
        point3D2.normalize();
        point3D.copy(point3D2);
        this.pa = (float)point3D.x;
        this.pb = (float)point3D.y;
        this.pc = (float)point3D.z;
        this.pd = (float)(-point3D.dot(this.p0));
        this.p0nx = (float)point3D.x;
        this.p0ny = (float)point3D.y;
        this.p0nz = (float)point3D.z;
        this.p1nx = (float)point3D.x;
        this.p1ny = (float)point3D.y;
        this.p1nz = (float)point3D.z;
        this.p2nx = (float)point3D.x;
        this.p2ny = (float)point3D.y;
        this.p2nz = (float)point3D.z;
        return this;
    }

    public void initSphereBox() {
        this.center.copy(this.p0);
        this.center.add(this.p1);
        this.center.add(this.p2);
        this.center.div(3.0);
        double d = this.center.distance2(this.p0);
        double d2 = this.center.distance2(this.p1);
        double d3 = this.center.distance2(this.p2);
        double d4 = d;
        if (d2 > d4) {
            d4 = d2;
        }
        if (d3 > d4) {
            d4 = d3;
        }
        this.sphereBox = (float)Math.sqrt(d4);
    }

    public void flipNormal() {
        Vertex3D vertex3D = this.p0;
        this.p0 = this.p2;
        this.p2 = vertex3D;
        float f = this.u0;
        this.u0 = this.u2;
        this.u2 = f;
        float f2 = this.v0;
        this.v0 = this.v2;
        this.v2 = f2;
    }

    public double getSphereBox() {
        return this.sphereBox;
    }

    public void setMaterial(IMaterial iMaterial) {
        this.material = (Material)iMaterial;
    }

    public IMaterial getMaterial() {
        return this.material;
    }

    public IVertex3D getVertex3D0() {
        return this.p0;
    }

    public IVertex3D getVertex3D1() {
        return this.p1;
    }

    public IVertex3D getVertex3D2() {
        return this.p2;
    }

    public IMesh3D getMesh3D() {
        return this.object;
    }

    public double getPA() {
        return this.pa;
    }

    public double getPB() {
        return this.pb;
    }

    public double getPC() {
        return this.pc;
    }

    public double getPD() {
        return this.pd;
    }

    public float getMappingU(int n) {
        switch (n) {
            case 0: {
                return this.u0;
            }
            case 1: {
                return this.u1;
            }
            case 2: {
                return this.u2;
            }
        }
        return 0.0f;
    }

    public float getMappingV(int n) {
        switch (n) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
            case 2: {
                return this.v2;
            }
        }
        return 0.0f;
    }

    public void setMappingU(int n, float f) {
        switch (n) {
            case 0: {
                this.u0 = f;
                break;
            }
            case 1: {
                this.u1 = f;
                break;
            }
            case 2: {
                this.u2 = f;
                break;
            }
        }
    }

    public void setMappingV(int n, float f) {
        switch (n) {
            case 0: {
                this.v0 = f;
                break;
            }
            case 1: {
                this.v1 = f;
                break;
            }
            case 2: {
                this.v2 = f;
                break;
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public float getVertex3D0Nx() {
        return this.p0nx;
    }

    public float getVertex3D0Ny() {
        return this.p0ny;
    }

    public float getVertex3D0Nz() {
        return this.p0nz;
    }

    public float getVertex3D1Nx() {
        return this.p1nx;
    }

    public float getVertex3D1Ny() {
        return this.p1ny;
    }

    public float getVertex3D1Nz() {
        return this.p1nz;
    }

    public float getVertex3D2Nx() {
        return this.p2nx;
    }

    public float getVertex3D2Ny() {
        return this.p2ny;
    }

    public float getVertex3D2Nz() {
        return this.p2nz;
    }

    public IPoint3D getCenter() {
        return this.center;
    }
}

