/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.Serializable;
import net.dzzd.access.IFace3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IVertex3D;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.Point3D;
import net.dzzd.core.Vertex3D;

public final class Face3D
implements IFace3D,
Serializable {
    Mesh3D object = null;
    int id;
    Vertex3D p0 = null;
    Vertex3D p1 = null;
    Vertex3D p2 = null;
    Point3D center = new Point3D();
    int smoothGroupMask = 0;
    float pa;
    float pb;
    float pc;
    float pd;
    float p0nx;
    float p0ny;
    float p0nz;
    float p1nx;
    float p1ny;
    float p1nz;
    float p2nx;
    float p2ny;
    float p2nz;
    float u0 = 0.0f;
    float u1 = 1.0f;
    float u2 = 1.0f;
    float v0 = 0.0f;
    float v1 = 0.0f;
    float v2 = 1.0f;
    Material material = null;
    float sphereBox;
    transient Face3D nextAlphaFace;

    public Face3D() {
    }

    public Face3D(IVertex3D iVertex3D, IVertex3D iVertex3D2, IVertex3D iVertex3D3) {
        this();
        this.p0 = (Vertex3D)iVertex3D;
        this.p1 = (Vertex3D)iVertex3D2;
        this.p2 = (Vertex3D)iVertex3D3;
    }

    Face3D setNormal() {
        double d = this.p0.x;
        double d2 = this.p0.y;
        double d3 = this.p0.z;
        double d4 = this.p1.x;
        double d5 = this.p1.y;
        double d6 = this.p1.z;
        double d7 = this.p2.x;
        double d8 = this.p2.y;
        double d9 = this.p2.z;
        double d10 = d4 - d;
        double d11 = d5 - d2;
        double d12 = d6 - d3;
        double d13 = d7 - d;
        double d14 = d8 - d2;
        double d15 = d9 - d3;
        double d16 = d11 * d15 - d12 * d14;
        double d17 = d12 * d13 - d10 * d15;
        double d18 = d10 * d14 - d11 * d13;
        double d19 = 1.0 / Math.sqrt(d16 * d16 + d17 * d17 + d18 * d18);
        this.pa = (float)(d16 *= d19);
        this.pb = (float)(d17 *= d19);
        this.pc = (float)(d18 *= d19);
        this.pd = (float)(-(d16 * d + d17 * d2 + d18 * d3));
        this.p0nx = (float)d16;
        this.p0ny = (float)d17;
        this.p0nz = (float)d18;
        this.p1nx = (float)d16;
        this.p1ny = (float)d17;
        this.p1nz = (float)d18;
        this.p2nx = (float)d16;
        this.p2ny = (float)d17;
        this.p2nz = (float)d18;
        return this;
    }

    public void initSphereBox() {
        this.center.copy(this.p0);
        this.center.add(this.p1);
        this.center.add(this.p2);
        this.center.div(3.0);
        double d = this.center.distance2(this.p0);
        double d2 = this.center.distance2(this.p1);
        double d3 = this.center.distance2(this.p2);
        double d4 = d;
        if (d2 > d4) {
            d4 = d2;
        }
        if (d3 > d4) {
            d4 = d3;
        }
        this.sphereBox = (float)Math.sqrt(d4);
    }

    public void flipNormal() {
        Vertex3D vertex3D = this.p0;
        this.p0 = this.p2;
        this.p2 = vertex3D;
        float f = this.u0;
        this.u0 = this.u2;
        this.u2 = f;
        float f2 = this.v0;
        this.v0 = this.v2;
        this.v2 = f2;
    }

    public double getSphereBox() {
        return this.sphereBox;
    }

    public void setMaterial(IMaterial iMaterial) {
        this.material = (Material)iMaterial;
    }

    public IMaterial getMaterial() {
        return this.material;
    }

    public IVertex3D getVertex3D0() {
        return this.p0;
    }

    public IVertex3D getVertex3D1() {
        return this.p1;
    }

    public IVertex3D getVertex3D2() {
        return this.p2;
    }

    public IMesh3D getMesh3D() {
        return this.object;
    }

    public double getPA() {
        return this.pa;
    }

    public double getPB() {
        return this.pb;
    }

    public double getPC() {
        return this.pc;
    }

    public double getPD() {
        return this.pd;
    }

    public float getMappingU(int n) {
        switch (n) {
            case 0: {
                return this.u0;
            }
            case 1: {
                return this.u1;
            }
            case 2: {
                return this.u2;
            }
        }
        return 0.0f;
    }

    public float getMappingV(int n) {
        switch (n) {
            case 0: {
                return this.v0;
            }
            case 1: {
                return this.v1;
            }
            case 2: {
                return this.v2;
            }
        }
        return 0.0f;
    }

    public void setMappingU(int n, float f) {
        switch (n) {
            case 0: {
                this.u0 = f;
                break;
            }
            case 1: {
                this.u1 = f;
                break;
            }
            case 2: {
                this.u2 = f;
                break;
            }
        }
    }

    public void setMappingV(int n, float f) {
        switch (n) {
            case 0: {
                this.v0 = f;
                break;
            }
            case 1: {
                this.v1 = f;
                break;
            }
            case 2: {
                this.v2 = f;
                break;
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public float getVertex3D0Nx() {
        return this.p0nx;
    }

    public float getVertex3D0Ny() {
        return this.p0ny;
    }

    public float getVertex3D0Nz() {
        return this.p0nz;
    }

    public float getVertex3D1Nx() {
        return this.p1nx;
    }

    public float getVertex3D1Ny() {
        return this.p1ny;
    }

    public float getVertex3D1Nz() {
        return this.p1nz;
    }

    public float getVertex3D2Nx() {
        return this.p2nx;
    }

    public float getVertex3D2Ny() {
        return this.p2ny;
    }

    public float getVertex3D2Nz() {
        return this.p2nz;
    }

    public IPoint3D getCenter() {
        return this.center;
    }
}

