/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/


import java.awt.*;
import java.applet.*;
import java.awt.image.*;

/**
 * Boot
 *
 * An Applet Boot class
 * 
 * @author Bruno Augier
 * @website: http://dzzd.net/
 * @version 1.00 2008/04/15
 */
public final class Boot extends Applet implements Runnable,AppletStub
{
	public static final long serialVersionUID = 0x00000001;
			
	private volatile int nbStart=0;
	private volatile Graphics g;		
	private volatile int bgColor;
	private volatile Container c;
	private volatile boolean loaded;
	private volatile Thread t;
	public  volatile Applet a;
	private volatile boolean bootToStart=false;
	private volatile Image bImage;
	private volatile Graphics bg;
	
		
	private int w()
	{
		return this.getSize().width;
	}
	
	private int h()
	{
		return this.getSize().height;
	}	 	
	
	private int nb=0;
	private long lTime;
	public void run()
	{
		
					
		try
		{
			this.lTime=System.currentTimeMillis();
			while(!this.loaded)
			{
				Color color=new Color(this.bgColor);
				this.c.setBackground(color);	
				this.bg.setColor(color);
				this.bg.fillRect(0,0,w(),h());
				
		
				int cx=this.w()>>1;
				int cy=this.h()>>1;
				for(int n=0;n<360;n++)
				{
					/*
					int r=255;
					int v=165+(n>>1);
					int b=75+n;
					*/
					int b=255;
					int v=165+(n>>2);
					int r=75+n>>1;
					r^=255;
					v^=255;
					b^=255;
					r+=32;
					v+=10;
					b+=4;
					
					
					this.bg.setColor(new Color(b|(v<<8)|(r<<16)));
					double a=(nb-n*0.5)*Math.PI/180.0;
					double ca=Math.cos(a);
					double sa=Math.sin(a);
					int x=cx+(int)(8.0*ca);
					int y=cy+(int)(8.0*sa);
					
					int x2=cx+(int)(12.0*ca);
					int y2=cy+(int)(12.0*sa);
					this.bg.drawLine(x,y,x2,y2);
				}
				
				this.g.drawImage(this.bImage,0,0,null);
				
				nb+=6;
				long time=System.currentTimeMillis();
				long delta=time-lTime;
				lTime=time;
				//if(delta<20)
					//Thread.sleep(20-delta);
				Thread.sleep(5);
				Thread.yield();	
					//System.out.println (nb);
			}
		}
		catch(InterruptedException ie)
		{
			ie.printStackTrace();
		}
		
	}
	
	public void paint(Graphics g)
	{
		
		if(this.nbStart++==0)
		{
			
						
			this.bImage=this.createImage(w(),h());
			this.bg=this.bImage.getGraphics();
			String sBgColor=this.getParameter("BOOTBGCOLOR");
			if(sBgColor!=null)
			{
				try
				{
					this.bgColor=Integer.parseInt(sBgColor,16);
				}
				catch(Exception e)
				{
					e.printStackTrace();
				}
				
			}	
			this.c=this.getParent();
			this.g=this.c.getGraphics();
			this.c.remove(this);	
							
			this.loaded=false;
			this.t=new Thread(this);
			this.t.start();
			
			String bootToStart=this.getParameter("BOOTTOSTART");
			if(bootToStart!=null && bootToStart.equals("TRUE"))
				this.bootToStart=true;
			String bootClass=this.getParameter("BOOTCLASS");
			
			Color color=new Color(this.bgColor);
			this.c.setBackground(color);		
			
			new AppletLoader(bootClass);
		}
		
		
		//super.paint(g);
		
	}
	
	private class AppletLoader implements Runnable
	{
		String name;
		
		AppletLoader(String name)
		{		
			this.name=name;
			Thread t=new Thread(this,"DZZD APPLET BOOT");
			t.start();	
		}
		
		public void run()
		{
			
			try
			{
				Thread.sleep(200);
				Boot.this.a=(Applet)Class.forName(this.name).newInstance();
				Boot.this.a.setVisible(false);
				
				{	
					Boot.this.a.setStub(Boot.this);
					Boot.this.c.add(Boot.this.a);
					Boot.this.a.resize(new Dimension(Boot.this.w(),Boot.this.h()));
					
					Boot.this.a.init();	
					if(!Boot.this.bootToStart)
						Boot.this.a.setVisible(true);				
					Boot.this.a.start();
					if(Boot.this.bootToStart)
						Boot.this.a.setVisible(true);
				}	
								
				Boot.this.loaded=true;
				Boot.this.t.join();
				
							
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
				
		}
		
	}
	
	public void start()
	{
		if(this.a!=null)
			this.a.start();
	}
	
	public void stop()
	{
		if(this.a!=null)
			this.a.stop();
	}
	
	public void destroy()
	{
		if(this.a!=null)
			this.a.destroy();
		this.a=null;
	}
	/*
	public void update(Graphics g)
	{
		
	}*/
		
	public void appletResize(int width, int height) 
	{
		if(this.a!=null)
			this.a.setSize(width,height);
	}
}
