/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/

package net.dzzd.access;

/** 
 *  Used for accessing to a HeightMap.
 *  <br>
 *  give a z value for a given homogeneous 2d pos x,y
 *
 *  @author Bruno Augier
 *  @version 1.0, 01/01/04
 *  @since 1.0
 *	@see IMesh3D
 */
public interface IHeightMap
{
	
	/**
	 * Gets z values for the given 2d pos x,y.
	 * 
	 * @param x x value, should be in the range 0.0-1.0
	 * @param y y value, should be in the range 0.0-1.0
	 * @return z value for the given 2d pos x,y, should be in the range 0.0-1.0
	 */		
	public double getAt(double x,double y);
}