/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/

package net.dzzd.core;

import net.dzzd.access.*;
import java.io.Serializable;

/** 
 *  This class represent an object point with 3 dimension x,y,z and a normal vx,vy,vz
 *  in 2 differents spaces (object & camra)
 *  @version 1.0
 *  @since 1.0
 *  @see Point3D
 *  @see Face3D
 *  @see Mesh3D
 *  @author Bruno Augier
 *
 *  Copyright Bruno Augier 2005 
 */
public final class Vertex3D extends Point3D implements IVertex3D,Serializable
{
	public static final long serialVersionUID = 0x00000001;
	int id;	
	
	public Vertex3D()
	{
		this(0,0,0);
	}

	public Vertex3D (double x,double y,double z)
	{
		super(x,y,z);
	}
	
	public IPoint3D getClone()
	{
		Vertex3D v=new Vertex3D(this.x,this.y,this.z);
		return v;
	}
}