/*
* This file is part of 3DzzD http://dzzd.net/.
*
* Released under LGPL
*
* 3DzzD is free software: you can redistribute it and/or modify
* it under the terms of the GNU Lesser General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* 3DzzD is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public License
* along with 3DzzD.  If not, see <http://www.gnu.org/licenses/>.
*
* Copyright 2005 - 2009 Bruno Augier
*/

package net.dzzd.test;
 
import java.awt.*;
import java.applet.*;

import net.dzzd.access.*;
import net.dzzd.*;
import net.dzzd.utils.*;



/**
 * Grid3D
 * 
 * a 3D grid factory
 */
public class Grid3D
{
	IVertex3D vertices[];
	IFace3D faces[];
	IMesh3D mesh;
	
	public Grid3D(int w,int h,IMaterial material)
	{
		this.vertices=DzzD.newVertex3DArray((w+1)*(h+1));
		this.faces=DzzD.newFace3DArray(w*h*2);
	
		for(int n=0;n<vertices.length;n++)
			vertices[n]=DzzD.newVertex3D();
			
		for(int y=0;y<h+1;y++)
			for(int x=0;x<w+1;x++)
			{
				double px=x;
				double py=y;
				
				if(y==0)
					py-=10000;
				
				if(y==h)
					py+=10000;
				
				if(x==0)
					px-=10000;
				
				if(x==w)
					px+=10000;
					
				vertices[x+y*(w+1)].set(px,0,py);
			}
			
		for(int y=0;y<h;y++)
		{
			for(int x=0;x<w;x++)
			{
				//double p1
				
				IFace3D face1=DzzD.newFace3D(vertices[x+y*(w+1)],vertices[(x+1)+(y+1)*(w+1)],vertices[(1+x)+y*(w+1)]);
				IFace3D face2=DzzD.newFace3D(vertices[x+y*(w+1)],vertices[x+(y+1)*(w+1)],vertices[(x+1)+(y+1)*(w+1)]);
				
				face1.setMaterial(material);
				face2.setMaterial(material);
				
				
				float ofsX=0f;
				/*
				if(x==0)
				{
					ofsX=-10f;
				}
				
				if(x==w-1)
				{
					ofsX=+10f;
				}*/
				
				float ofsY=0f;/*
				if(y==0)
				{
					ofsY=-10f;
				}
				
				if(y==h-1)
				{
					ofsY=+10f;
				}*/
				
				float v0x=(float)face1.getVertex3D0().getX();
				float v1x=(float)face1.getVertex3D1().getX();
				float v2x=(float)face1.getVertex3D2().getX();
				float v3x=(float)face2.getVertex3D1().getX();
				float v0y=(float)face1.getVertex3D0().getZ();
				float v1y=(float)face1.getVertex3D1().getZ();
				float v2y=(float)face1.getVertex3D2().getZ();
				float v3y=(float)face2.getVertex3D1().getZ();
				
				/*
				face1.setMappingUV(x+ofsX,y+ofsY,x+1+ofsX,y+1+ofsY,x+1+ofsX,y+ofsY);
				face2.setMappingUV(x+ofsX,y+ofsY,x+0+ofsX,y+1+ofsY,x+1+ofsX,y+1+ofsY);
				*/
				
				face1.setMappingUV(v0x,v0y,v1x,v1y,v2x,v2y);
				face2.setMappingUV(v0x,v0y,v3x,v3y,v1x,v1y);
				
				/*
				face1.setMappingUV(v0x,v0y,v1x,v1y,v2x,v2y);
				face2.setMappingUV(v0x,v0y,v1x,v1y,v3x,v3y);
				*/
				
				faces[(x+y*w)*2]=face1;
				faces[(x+y*w)*2+1]=face2;
				
				face1.setSmoothGroup(1);
				face2.setSmoothGroup(1);
			}
		}
		
		this.mesh=DzzD.newMesh3D(vertices,faces);
	}
	
	public IMesh3D getMesh3D()
	{
		return this.mesh;
	}
}
