/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Hashtable;
import net.dzzd.DzzD;
import net.dzzd.access.IAxis3D;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IPoint3D;
import net.dzzd.access.IScene3DLoader;
import net.dzzd.access.IScene3DObject;
import net.dzzd.access.ISceneObject;
import net.dzzd.access.ITexture;
import net.dzzd.core.Axis3D;
import net.dzzd.core.Camera3D;
import net.dzzd.core.Face3D;
import net.dzzd.core.MappingUV;
import net.dzzd.core.Material;
import net.dzzd.core.Mesh3D;
import net.dzzd.core.MonitoredSceneObject;
import net.dzzd.core.Point3D;
import net.dzzd.core.Scene3DObject;
import net.dzzd.core.Scene3DObjectAnimator;
import net.dzzd.core.SceneObject;
import net.dzzd.core.Texture;
import net.dzzd.core.URLTexture;
import net.dzzd.core.Vertex3D;
import net.dzzd.utils.Log;
import net.dzzd.utils.io.IOManagerAsynch;

public final class Scene3DLoader3DS
extends MonitoredSceneObject
implements IScene3DLoader,
Runnable {
    private static final int FILE_VERSION = 2;
    private static final int KEYFRAME_VERSION = 5;
    private static final int RGBF = 16;
    private static final int RGBB = 17;
    private static final int RGBBG = 18;
    private static final int RGBFG = 19;
    private static final int PERCENTI = 48;
    private static final int PERCENTF = 49;
    private static final int MAIN3DS = 19789;
    private static final int EDIT3DS = 15677;
    private static final int MESH_VERSION = 15678;
    private static final int UNIT = 256;
    private static final int BGCOLOR = 4608;
    private static final int SHADOW_MAP_SIZE = 5152;
    private static final int OBJECT = 16384;
    private static final int OBJECT_HIDDEN = 16400;
    private static final int OBJECT_DONT_CAST_SHADOW = 16402;
    private static final int OBJECT_DONT_RECV_SHADOW = 16407;
    private static final int LIGHT = 17920;
    private static final int CAMERA = 18176;
    private static final int CAMERA_ATMOS_RANGE = 18208;
    private static final int TRIMESH = 16640;
    private static final int VERTEXL = 16656;
    private static final int FACEL = 16672;
    private static final int SMOOTHL = 16720;
    private static final int FACEM = 16688;
    private static final int MAPPINGVL = 16704;
    private static final int OBJAXES = 16736;
    private static final int MATERIAL = 45055;
    private static final int MATERIALNAME = 40960;
    private static final int MATERIALAMBIENTCOLOR = 40976;
    private static final int MATERIALDIFFUSECOLOR = 40992;
    private static final int MATERIALSPECULARCOLOR = 41008;
    private static final int MATERIALSHINEPERCENT = 41024;
    private static final int MATERIALSHINEFPERCENT = 41025;
    private static final int MATERIALTRANSPERCENT = 41040;
    private static final int MATERIALTRANSFPERCENT = 41042;
    private static final int MATERIALTWOSIDE = 41089;
    private static final int MATERIALILLUMPERCENT = 41092;
    private static final int MATERIALTEXTUREDIFF = 41472;
    private static final int MATERIALTEXTUREDIFF2 = 41786;
    private static final int MATERIALTEXTURESPEC = 41476;
    private static final int MATERIALTEXTUREOPAC = 41488;
    private static final int MATERIALTEXTUREENV = 41504;
    private static final int MATERIALTEXTUREBUMP = 41520;
    private static final int MATERIALTEXTURESHIN = 41788;
    private static final int MATERIALTEXTUREILLUM = 41789;
    private static final int MAPPINGFILE = 41728;
    private static final int MAPPINGOFFSETU = 41816;
    private static final int MAPPINGOFFSETV = 41818;
    private static final int MAPPINGSCALEU = 41812;
    private static final int MAPPINGSCALEV = 41814;
    private static final int KEYF3DS = 45056;
    private static final int KEYFOBJFRAME = 45058;
    private static final int KEYFCAMFRAME = 45059;
    private static final int KEYFCAMTARGETFRAME = 45060;
    private static final int KEYFCAMFOVFRAME = 45091;
    private static final int KEYFLIGHTFRAME = 45061;
    private static final int KEYFSPOTLIGHTFRAME = 45063;
    private static final int KEYFSPOTLIGHTTARGETFRAME = 45062;
    private static final int KEYFHEADERACTIVE = 45064;
    private static final int KEYFHEADERCURRENT = 45065;
    private static final int KEYFHEADERGLOBAL = 45066;
    private static final int KEYFHIER = 45072;
    private static final int KEYFNAME = 45073;
    private static final int KEYFPIVOT = 45075;
    private static final int KEYFBOX = 45076;
    private static final int KEYFTRANS = 45088;
    private static final int KEYFROT = 45089;
    private static final int KEYFZOOM = 45090;
    private static final int KEYFFOV = 45091;
    private static final int KEYFROLL = 45092;
    private static final int KEYFCOL = 45093;
    private static final int KEYFMORPH = 45094;
    private static final int KEYFHIDE = 45097;
    private static final int KEYFID = 45104;
    private Scene3DObject[] objets3D;
    private Point3D[] key3DTrans;
    private Point3D[] key3DRotAxe;
    private double[] key3DRotAng;
    private Point3D[] key3DZoom;
    private Vertex3D[][] vertice3D;
    private Texture[] textures;
    public Scene3DObjectAnimator[] animators;
    private ByteArrayInputStream input;
    private int inputSize;
    private String mappingFileName;
    private String fileName;
    private String fileFolder;
    private String textureFolder;
    private String baseURL;
    private Vertex3D[] cPoints3D;
    private float[] mappingU;
    private float[] mappingV;
    private Face3D[] cPolygones3D;
    private String lastObjectName;
    private int nbObjet;
    private Scene3DObject[] tObjets3D;
    private Scene3DObject cObjet;
    private int cObjetId;
    private Axis3D cAxe;
    private int nbMaterial;
    private int nbTexture;
    private Material[] tMateriaux3D;
    private Material cMateriau;
    private MappingUV cMapping;
    private int nbBytesDecoded;
    private int meshVersion;
    private int fileVersion;
    private float unit;
    private int backgroundColor;
    private boolean isKeyFrame;
    private int keyFrameVersion;
    private int keyFrameRevision;
    private String keyFrameFileName;
    private long KeyFrameNbFrame;
    private int[] chunkStack;
    private int chunkStackProof;
    private Hashtable textureCache = new Hashtable();

    public String toString() {
        String string = "";
        string = string + " File Version     : " + this.fileVersion + "\n";
        string = string + " Mesh Version     : " + this.meshVersion + "\n";
        string = string + " Units            : " + this.unit + "\n";
        string = string + " Background Color : " + this.backgroundColor + "\n";
        if (this.isKeyFrame) {
            string = string + " Keyframe Version     : " + this.keyFrameVersion + "\n";
            string = string + " Keyframe Revision     :" + this.keyFrameRevision + "\n";
            string = string + " Keyframe File Name   : " + this.keyFrameFileName + "\n";
            string = string + " Keyframe Nb Frames   : " + this.KeyFrameNbFrame + "\n";
        }
        return string;
    }

    public void loadScene3D(String string, String string2) {
        this.loadScene3D(string, "", string2, "");
    }

    public void loadScene3D(String string, String string2, String string3) {
        this.loadScene3D(string, "", string2, string3);
    }

    public void loadScene3D(String string, String string2, String string3, String string4) {
        this.reset();
        this.baseURL = string;
        this.fileFolder = string2;
        this.fileName = string3;
        this.textureFolder = string4;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void run() {
        this.loadAndDecode();
    }

    private void pushChunk(int n) {
        this.chunkStack[this.chunkStackProof++] = n;
    }

    private int popChunk() {
        return this.chunkStack[--this.chunkStackProof];
    }

    private int getLastChunk() {
        return this.chunkStack[this.chunkStackProof - 1];
    }

    private int getLastParentChunk() {
        return this.chunkStack[this.chunkStackProof - 2];
    }

    public void reset() {
        super.reset();
        this.nbBytesDecoded = 0;
        this.meshVersion = 0;
        this.fileVersion = 0;
        this.unit = 0.0f;
        this.backgroundColor = 0;
        this.key3DTrans = new Point3D[16384];
        this.key3DRotAxe = new Point3D[16384];
        this.key3DRotAng = new double[16384];
        this.key3DZoom = new Point3D[16384];
        this.isKeyFrame = false;
        this.animators = new Scene3DObjectAnimator[16384];
        this.cObjetId = -1;
        this.nbObjet = 0;
        this.tObjets3D = new Scene3DObject[16384];
        this.nbMaterial = 0;
        this.tMateriaux3D = new Material[16384];
        this.nbTexture = 0;
        this.textures = new Texture[16384];
        this.chunkStackProof = 0;
        this.chunkStack = new int[1024];
    }

    private void loadAndDecode() {
        try {
            Point3D point3D;
            Point3D point3D2;
            Point3D point3D3;
            Object object;
            int n;
            IOManagerAsynch iOManagerAsynch = new IOManagerAsynch();
            iOManagerAsynch.downloadData(this.baseURL + this.fileFolder + this.fileName);
            while (iOManagerAsynch.isLoading()) {
                Thread.sleep(1L);
            }
            if (iOManagerAsynch.isLoadingError()) {
                throw new IOException("Error loading data from " + this.baseURL + this.fileFolder + this.fileName);
            }
            this.inputSize = iOManagerAsynch.getData().length;
            this.input = new ByteArrayInputStream(iOManagerAsynch.getData());
            this.setProgress(50);
            for (int i = 0; i < iOManagerAsynch.getData().length; i += this.decodeChunk(0)) {
            }
            this.objets3D = new Scene3DObject[this.nbObjet + 1];
            this.objets3D[0] = new Mesh3D();
            this.objets3D[0].setName(this.fileName);
            double d = 1.0;
            double d2 = 1.0;
            double d3 = 1.0;
            for (n = 0; n < this.nbObjet; ++n) {
                Object object2;
                Thread.yield();
                this.objets3D[n + 1] = this.cObjet = this.tObjets3D[n];
                object = this.cObjet.axes;
                point3D3 = ((Axis3D)object).origine;
                point3D2 = ((Axis3D)object).axeX;
                point3D = ((Axis3D)object).axeY;
                Point3D point3D4 = ((Axis3D)object).axeZ;
                d = point3D2.norm();
                d2 = point3D.norm();
                d3 = point3D4.norm();
                point3D2.add(point3D3);
                point3D.add(point3D3);
                point3D4.add(point3D3);
                ((Axis3D)object).normalize();
                if (this.cObjet instanceof Mesh3D) {
                    object2 = ((Mesh3D)this.cObjet).vertices3D;
                    for (int i = 0; i < ((Vertex3D[])object2).length; ++i) {
                        object2[i].toLocalAxis((IAxis3D)object).zoom(1.0 / d, 1.0 / d2, 1.0 / d3);
                    }
                }
                point3D2.sub(point3D3);
                point3D.sub(point3D3);
                point3D4.sub(point3D3);
                object2 = new Point3D();
                ((Point3D)object2).copy(point3D2).cross(point3D);
                if (point3D4.dot((IPoint3D)object2) < 0.0) {
                    point3D2.mul(-1.0);
                    point3D.mul(-1.0);
                    point3D4.mul(-1.0);
                    d = -d;
                    d2 = -d2;
                    d3 = -d3;
                }
                point3D2.add(point3D3);
                point3D.add(point3D3);
                point3D4.add(point3D3);
                this.cObjet.axes.getPosition(this.cObjet.position);
                this.cObjet.axes.getRotationXZY(this.cObjet.rotation);
                this.cObjet.zoom.set(d, d2, d3);
            }
            for (n = 1; n < this.objets3D.length; ++n) {
                Thread.yield();
                this.cObjet = this.objets3D[n];
                this.cObjet.axes.init();
                this.cObjet.axes.set(this.cObjet.pivot, this.cObjet.position, this.cObjet.rotation);
            }
            for (n = 1; n < this.objets3D.length; ++n) {
                Thread.yield();
                this.cObjet = this.objets3D[n];
                if (this.cObjet.parent == null) {
                    this.cObjet.parent = this.objets3D[0];
                }
                this.cObjet.setParent(this.cObjet.parent);
            }
            for (n = 1; n < this.objets3D.length; ++n) {
                Thread.yield();
                this.cObjet = this.objets3D[n];
                object = DzzD.newAxis3D();
                object.copy(this.cObjet.axes);
                if (this.cObjet.parent == null) {
                    this.cObjet.parent = this.objets3D[0];
                }
                this.cObjet.toLocalAxe(this.cObjet.parent.axes);
                this.cObjet.axes.copy((IAxis3D)object);
            }
            try {
                if (this.isKeyFrame) {
                    for (n = 1; n < this.objets3D.length; ++n) {
                        Thread.yield();
                        this.cObjet = this.objets3D[n];
                        if (this.cObjet.id == -1) continue;
                        object = DzzD.newAxis3D();
                        object.copy(this.cObjet.axes);
                        point3D3 = this.key3DRotAxe[this.cObjet.id];
                        if (point3D3 != null) {
                            double d4 = this.key3DRotAng[this.cObjet.id];
                            this.cObjet.axes.init();
                            this.cObjet.axes.rotate(d4, -point3D3.x, -point3D3.y, -point3D3.z);
                            this.cObjet.axes.getRotationXZY(this.cObjet.rotation);
                            this.cObjet.axes.copy((IAxis3D)object);
                        }
                        if ((point3D2 = this.key3DTrans[this.cObjet.id]) != null) {
                            this.cObjet.position.set(point3D2.x, point3D2.y, point3D2.z);
                            if (this.cObjet.parent != null) {
                                this.cObjet.position.add(this.cObjet.parent.pivot);
                            }
                        }
                        if ((point3D = this.key3DZoom[this.cObjet.id]) != null) {
                            this.cObjet.zoom.set(point3D.x, point3D.y, point3D.z);
                        }
                        this.cObjet.axes.copy((IAxis3D)object);
                    }
                }
                for (n = 1; n < this.objets3D.length; ++n) {
                    Thread.yield();
                    this.cObjet = this.objets3D[n];
                    if (this.cObjet.id == -1 || this.animators[this.cObjet.id] == null) continue;
                    this.cObjet.setScene3DObjectAnimator(this.animators[this.cObjet.id]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                Log.log(arrayIndexOutOfBoundsException);
            }
            catch (NullPointerException nullPointerException) {
                Log.log(nullPointerException);
            }
            for (int i = 1; i < this.objets3D.length; ++i) {
                Thread.yield();
                this.cObjet = this.objets3D[i];
                object = this.cObjet.zoom;
                this.cObjet.zoom(((Point3D)object).x, ((Point3D)object).y, ((Point3D)object).z);
            }
            this.setFinished(true);
            this.setProgress(100);
            return;
        }
        catch (Exception exception) {
            Log.log(exception);
            this.setError(true);
            this.setFinished(true);
            return;
        }
    }

    public IScene3DLoader getScene3DLoader() {
        return this;
    }

    public IScene3DObject[] getScene3DObjects() {
        return this.objets3D;
    }

    public ISceneObject[] getSceneObjects() {
        int n;
        ISceneObject[] iSceneObjectArray = new SceneObject[this.nbMaterial + this.nbTexture];
        for (n = 0; n < this.nbMaterial; ++n) {
            iSceneObjectArray[n] = this.tMateriaux3D[n];
        }
        for (n = 0; n < this.nbTexture; ++n) {
            iSceneObjectArray[this.nbMaterial + n] = this.textures[n];
        }
        return iSceneObjectArray;
    }

    public IMaterial[] getMaterials() {
        IMaterial[] iMaterialArray = new Material[this.nbMaterial];
        for (int i = 0; i < this.nbMaterial; ++i) {
            iMaterialArray[i] = this.tMateriaux3D[i];
        }
        return iMaterialArray;
    }

    public ITexture[] getTextures() {
        ITexture[] iTextureArray = new Texture[this.nbTexture];
        for (int i = 0; i < this.nbTexture; ++i) {
            iTextureArray[i] = this.textures[i];
        }
        return iTextureArray;
    }

    private int decodeChunk(int n) {
        int n2;
        Thread.yield();
        DzzD.sleep(1L);
        int n3 = 6;
        int n4 = this.getUShort();
        int n5 = this.getInt();
        if (n5 < 0) {
            return 0;
        }
        this.pushChunk(n4);
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print(" ");
        }
        Log.log(n + " - ID=" + Integer.toHexString(n4) + " LONGUEUR=" + n5);
        switch (n4) {
            case 2: {
                long l = this.getUInt();
                this.fileVersion = (int)l;
                n3 += 4;
                break;
            }
            case 5: {
                long l = this.getUInt();
                this.keyFrameVersion = (int)l;
                n3 += 4;
                break;
            }
            case 15678: {
                long l = this.getUInt();
                this.meshVersion = (int)l;
                n3 += 4;
                break;
            }
            case 256: {
                this.unit = this.getFloat();
                n3 += 4;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 4608: {
                do {
                    n2 = this.getUShort();
                    int n6 = this.getInt();
                    n3 += 6;
                    switch (n2) {
                        case 16: 
                        case 19: {
                            this.backgroundColor = this.readFloatColor();
                            n3 += 12;
                            break;
                        }
                        case 17: 
                        case 18: {
                            this.backgroundColor = this.readByteColor();
                            n3 += 3;
                        }
                    }
                } while (n3 < n5);
                break;
            }
            case 16384: {
                this.lastObjectName = this.getString();
                n3 += this.lastObjectName.length() + 1;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 16400: {
                ((Mesh3D)this.cObjet).setVisible(false);
                break;
            }
            case 16402: {
                if (!(this.cObjet instanceof Mesh3D)) break;
                ((Mesh3D)this.cObjet).setCastShadow(false);
                break;
            }
            case 16407: {
                if (!(this.cObjet instanceof Mesh3D)) break;
                ((Mesh3D)this.cObjet).setRecvShadow(false);
                break;
            }
            case 18208: {
                float f = this.getFloat();
                float f2 = this.getFloat();
                n3 += 8;
                break;
            }
            case 18176: {
                this.cObjet = new Camera3D();
                this.cObjet.id = -1;
                this.cObjet.nom = this.lastObjectName;
                this.cObjet.axes = this.cAxe = new Axis3D();
                this.tObjets3D[this.nbObjet] = this.cObjet;
                ++this.nbObjet;
                float f = this.getFloat();
                float f3 = this.getFloat();
                float f4 = this.getFloat();
                float f5 = this.getFloat();
                float f6 = this.getFloat();
                float f7 = this.getFloat();
                float f8 = this.getFloat();
                float f9 = this.getFloat();
                double d = 360.0 * Math.atan(44.1828 / (double)(f9 * 2.0f)) / Math.PI;
                this.cObjet.position.set(f, f4, f3);
                this.cObjet.axes.origine.set(f, f4, f3);
                this.cObjet.axes.axeZ.set(f5 - f, f7 - f4, f6 - f3);
                this.cObjet.axes.axeX.set(f6 - f3, 0.0, -(f5 - f));
                this.cObjet.axes.axeY.copy(this.cObjet.axes.axeZ).cross(this.cObjet.axes.axeX);
                this.cObjet.axes.axeX.normalize();
                this.cObjet.axes.axeY.normalize();
                this.cObjet.axes.axeZ.normalize();
                this.cObjet.rotation.z = f8;
                this.cObjet.pivot.set(0.0, 0.0, 0.0);
                if (this.meshVersion == 0) {
                    f9 = (float)((Camera3D)this.cObjet).width;
                }
                ((Camera3D)this.cObjet).focus = f9;
                n3 += 32;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 17920: {
                float f = this.getFloat();
                float f10 = this.getFloat();
                float f11 = this.getFloat();
                n3 += 12;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 16640: {
                this.cObjet = new Mesh3D();
                this.cObjet.nom = this.lastObjectName;
                this.cObjet.id = -1;
                this.tObjets3D[this.nbObjet] = this.cObjet;
                ++this.nbObjet;
                this.cAxe = new Axis3D();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                this.cObjet.axes = this.cAxe;
                if (this.mappingU == null || this.mappingV == null) break;
                for (int i = 0; i < this.cPolygones3D.length; ++i) {
                    Face3D face3D = this.cPolygones3D[i];
                    int n7 = face3D.p0.id;
                    int n8 = face3D.p1.id;
                    int n9 = face3D.p2.id;
                    face3D.u0 = this.mappingU[n7];
                    face3D.v0 = this.mappingV[n7];
                    face3D.u1 = this.mappingU[n8];
                    face3D.v1 = this.mappingV[n8];
                    face3D.u2 = this.mappingU[n9];
                    face3D.v2 = this.mappingV[n9];
                }
                this.mappingU = null;
                this.mappingV = null;
                break;
            }
            case 16656: {
                int n10 = this.getUShort();
                n3 += 2;
                this.cPoints3D = new Vertex3D[n10];
                for (int i = 0; i < n10; ++i) {
                    float f = this.getFloat();
                    float f12 = this.getFloat();
                    float f13 = this.getFloat();
                    this.cPoints3D[i] = new Vertex3D(f, f13, f12);
                    this.cPoints3D[i].id = i;
                    n3 += 12;
                }
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 16672: {
                int n11 = this.getUShort();
                n3 += 2;
                this.cPolygones3D = new Face3D[n11];
                for (int i = 0; i < n11; ++i) {
                    int n12 = this.getUShort();
                    int n13 = this.getUShort();
                    int n14 = this.getUShort();
                    int n15 = this.getUShort();
                    Vertex3D[] vertex3DArray = new Vertex3D[]{this.cPoints3D[n14], this.cPoints3D[n13], this.cPoints3D[n12]};
                    this.cPolygones3D[i] = new Face3D(vertex3DArray[0], vertex3DArray[1], vertex3DArray[2]);
                    n3 += 8;
                }
                ((Mesh3D)this.cObjet).vertices3D = this.cPoints3D;
                ((Mesh3D)this.cObjet).faces3D = this.cPolygones3D;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 16720: {
                int n16 = this.cPolygones3D.length;
                for (int i = 0; i < n16; ++i) {
                    int n17;
                    this.cPolygones3D[i].smoothGroupMask = n17 = this.getInt();
                    n3 += 4;
                }
                break;
            }
            case 16688: {
                String string = this.getString();
                n3 += string.length() + 1;
                this.cMateriau = this.getTempMateriauByName(string);
                int n18 = this.getUShort();
                n3 += 2;
                for (int i = 0; i < n18; ++i) {
                    int n19 = this.getUShort();
                    this.cPolygones3D[n19].material = this.cMateriau;
                    n3 += 2;
                }
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 16704: {
                int n20 = this.getUShort();
                n3 += 2;
                this.mappingU = new float[n20];
                this.mappingV = new float[n20];
                for (int i = 0; i < n20; ++i) {
                    float f = this.getFloat();
                    float f14 = this.getFloat();
                    this.mappingU[i] = f;
                    this.mappingV[i] = -f14;
                    n3 += 8;
                }
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 16736: {
                double d = this.getFloat();
                double d2 = this.getFloat();
                double d3 = this.getFloat();
                this.cAxe.axeX.set(d, d3, d2);
                d = this.getFloat();
                d2 = this.getFloat();
                d3 = this.getFloat();
                this.cAxe.axeZ.set(d, d3, d2);
                d = this.getFloat();
                d2 = this.getFloat();
                d3 = this.getFloat();
                this.cAxe.axeY.set(d, d3, d2);
                d = this.getFloat();
                d2 = this.getFloat();
                d3 = this.getFloat();
                this.cAxe.origine.set(d, d3, d2);
                n3 += 48;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45055: {
                this.tMateriaux3D[this.nbMaterial] = this.cMateriau = new Material();
                ++this.nbMaterial;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 40960: {
                this.cMateriau.nom = this.getString();
                n3 += this.cMateriau.nom.length() + 1;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 40976: {
                do {
                    int n21 = this.getUShort();
                    int n22 = this.getInt();
                    n3 += 6;
                    switch (n21) {
                        case 16: 
                        case 19: {
                            this.cMateriau.ambientColor = this.readFloatColor();
                            n3 += 12;
                            break;
                        }
                        case 17: 
                        case 18: {
                            this.cMateriau.ambientColor = this.readByteColor();
                            n3 += 3;
                        }
                    }
                } while (n3 < n5);
                break;
            }
            case 40992: {
                do {
                    int n23 = this.getUShort();
                    int n24 = this.getInt();
                    n3 += 6;
                    switch (n23) {
                        case 16: 
                        case 19: {
                            this.cMateriau.diffuseColor = this.readFloatColor();
                            n3 += 12;
                            break;
                        }
                        case 17: 
                        case 18: {
                            this.cMateriau.diffuseColor = this.readByteColor();
                            n3 += 3;
                        }
                    }
                } while (n3 < n5);
                break;
            }
            case 41008: {
                do {
                    int n25 = this.getUShort();
                    int n26 = this.getInt();
                    n3 += 6;
                    switch (n25) {
                        case 16: 
                        case 19: {
                            this.cMateriau.specularColor = this.readFloatColor();
                            n3 += 12;
                            break;
                        }
                        case 17: 
                        case 18: {
                            this.cMateriau.specularColor = this.readByteColor();
                            n3 += 3;
                        }
                    }
                } while (n3 < n5);
                break;
            }
            case 41024: {
                int n27 = this.getUShort();
                int n28 = this.getInt();
                n3 += 6;
                switch (n27) {
                    case 49: {
                        this.cMateriau.specularPower = this.readFloatPercent();
                        n3 += 4;
                        break;
                    }
                    case 48: {
                        this.cMateriau.specularPower = this.readIntPercent();
                        n3 += 2;
                    }
                }
                break;
            }
            case 41089: {
                this.cMateriau.twoSide = true;
                break;
            }
            case 41092: {
                int n29 = this.getUShort();
                int n30 = this.getInt();
                n3 += 6;
                switch (n29) {
                    case 49: {
                        this.cMateriau.selfIlluminationLevel = this.readFloatPercent();
                        n3 += 4;
                        break;
                    }
                    case 48: {
                        this.cMateriau.selfIlluminationLevel = this.readIntPercent();
                        n3 += 2;
                    }
                }
                break;
            }
            case 41025: {
                int n31 = this.getUShort();
                int n32 = this.getInt();
                n3 += 6;
                switch (n31) {
                    case 49: {
                        this.cMateriau.specularLevel = this.readFloatPercent() * 255 / 100;
                        n3 += 4;
                        break;
                    }
                    case 48: {
                        this.cMateriau.specularLevel = this.readIntPercent() * 255 / 100;
                        n3 += 2;
                    }
                }
                break;
            }
            case 41040: {
                int n33 = this.getUShort();
                int n34 = this.getInt();
                n3 += 6;
                switch (n33) {
                    case 49: {
                        this.cMateriau.alphaLevel = this.readFloatPercent() * 255 / 100;
                        n3 += 4;
                        break;
                    }
                    case 48: {
                        this.cMateriau.alphaLevel = this.readIntPercent() * 255 / 100;
                        n3 += 2;
                    }
                }
                break;
            }
            case 41042: {
                int n35 = this.getUShort();
                int n36 = this.getInt();
                n3 += 6;
                switch (n35) {
                    case 49: {
                        this.cMateriau.alphaFalloff = this.readFloatPercent() * 255 / 100;
                        n3 += 4;
                        break;
                    }
                    case 48: {
                        this.cMateriau.alphaFalloff = this.readIntPercent() * 255 / 100;
                        n3 += 2;
                    }
                }
                break;
            }
            case 41472: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41786: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41520: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                int n37 = this.getUShort();
                int n38 = this.getInt();
                int n39 = this.readIntPercent();
                Log.log("chunkId=" + n37);
                Log.log("len=" + n38);
                Log.log("bumpPercent=" + n39);
                n3 += 8;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41504: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41488: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41476: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41788: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41789: {
                this.cMateriau.mapping = this.cMapping = new MappingUV();
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41728: {
                String string = this.getString();
                n3 += string.length() + 1;
                String string2 = this.textureFolder + string;
                URLTexture uRLTexture = (URLTexture)this.textureCache.get(string2);
                if (uRLTexture == null) {
                    uRLTexture = new URLTexture();
                    uRLTexture.nom = string;
                    uRLTexture.sourceFile = string;
                    uRLTexture.baseURL = this.baseURL + this.textureFolder;
                    this.textureCache.put(string2, uRLTexture);
                    this.textures[this.nbTexture++] = uRLTexture;
                }
                if (this.getLastParentChunk() == 41472) {
                    uRLTexture.type = 1;
                    this.cMateriau.diffuseTexture = uRLTexture;
                }
                if (this.getLastParentChunk() == 41520) {
                    uRLTexture.type = 4;
                    this.cMateriau.bumpNormalTexture = uRLTexture;
                }
                if (this.getLastParentChunk() == 41504) {
                    uRLTexture.type = 5;
                    this.cMateriau.envTexture = uRLTexture;
                }
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 41816: {
                float f = this.getFloat();
                n3 += 4;
                this.cMapping.ofsU = f;
                break;
            }
            case 41818: {
                float f = this.getFloat();
                n3 += 4;
                this.cMapping.ofsV = f;
                break;
            }
            case 45072: {
                Scene3DObject scene3DObject;
                this.lastObjectName = this.getString();
                n3 += this.lastObjectName.length() + 1;
                int n40 = this.getUShort();
                int n41 = this.getUShort();
                int n42 = this.getShort();
                n3 += 6;
                if (this.meshVersion >= 3 && (n40 & 0x4000) == 0 && !this.lastObjectName.equals("$$$DUMMY")) {
                    this.cObjet = (Scene3DObject)this.getTempObjetByName(this.lastObjectName).getClone(false);
                    this.cObjet.nom = "Instance" + this.nbObjet;
                    this.cObjet.id = this.cObjetId;
                    this.tObjets3D[this.nbObjet] = this.cObjet;
                    ++this.nbObjet;
                } else if (this.lastObjectName.equals("$$$DUMMY")) {
                    this.cObjet = new Mesh3D();
                    this.cObjet.nom = "$$$DUMMY";
                    this.cObjet.id = this.cObjetId;
                    this.tObjets3D[this.nbObjet] = this.cObjet;
                    ++this.nbObjet;
                } else {
                    this.cObjet = this.getTempObjetByName(this.lastObjectName);
                    if (!(this.cObjet instanceof Camera3D) || this.getLastParentChunk() == 45060) {
                        // empty if block
                    }
                }
                this.cObjet.id = this.cObjetId;
                if (n42 != 65535 && (scene3DObject = this.getTempObjetById(n42)) != null) {
                    this.cObjet.parent = scene3DObject;
                }
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45073: {
                String string;
                this.cObjet.nom = string = this.getString();
                n3 += string.length() + 1;
                break;
            }
            case 45104: {
                int n43 = this.getUShort();
                n3 += 2;
                this.cObjetId = n43;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45088: {
                int n44;
                int n45 = this.getShort();
                n3 += 2;
                for (n44 = 0; n44 < 8; ++n44) {
                    byte by = (byte)this.getByte();
                    ++n3;
                }
                n44 = (int)this.getUInt();
                n3 += 4;
                Point3D point3D = new Point3D();
                Point3D point3D2 = new Point3D();
                if (this.animators[this.cObjetId] == null) {
                    this.animators[this.cObjetId] = new Scene3DObjectAnimator();
                }
                for (int i = 0; i < n44; ++i) {
                    int n46 = (int)this.getUInt();
                    n3 += 4;
                    int n47 = this.getShort();
                    n3 += 2;
                    if ((n47 & 1) != 0) {
                        this.getFloat();
                        n3 += 4;
                    }
                    if ((n47 & 2) != 0) {
                        this.getFloat();
                        n3 += 4;
                    }
                    if ((n47 & 4) != 0) {
                        this.getFloat();
                        n3 += 4;
                    }
                    if ((n47 & 8) != 0) {
                        this.getFloat();
                        n3 += 4;
                    }
                    if ((n47 & 0x10) != 0) {
                        this.getFloat();
                        n3 += 4;
                    }
                    double d = this.getFloat();
                    double d4 = this.getFloat();
                    double d5 = this.getFloat();
                    if (i == 0) {
                        this.key3DTrans[this.cObjetId] = new Point3D(d, d5, d4);
                    }
                    point3D.set(d, d5, d4);
                    Point3D point3D3 = new Point3D();
                    point3D3.copy(point3D);
                    this.animators[this.cObjetId].addKeyPosition(n46 * 30, point3D3);
                    point3D2.copy(point3D);
                    n3 += 12;
                }
                break;
            }
            case 45089: {
                int n48;
                int n49 = this.getShort();
                n3 += 2;
                for (n48 = 0; n48 < 8; ++n48) {
                    byte by = (byte)this.getByte();
                    ++n3;
                }
                n48 = (int)this.getUInt();
                n3 += 4;
                Axis3D axis3D = new Axis3D();
                axis3D.init();
                Point3D point3D = new Point3D();
                Point3D point3D4 = new Point3D();
                if (this.animators[this.cObjetId] == null) {
                    this.animators[this.cObjetId] = new Scene3DObjectAnimator();
                }
                for (int i = 0; i < n48; ++i) {
                    int n50 = (int)this.getUInt();
                    n3 += 4;
                    int n51 = this.getShort();
                    n3 += 2;
                    double d = this.getFloat();
                    n3 += 4;
                    double d6 = this.getFloat();
                    double d7 = this.getFloat();
                    double d8 = this.getFloat();
                    if (d > Math.PI && i != 0) {
                        d = Math.PI * 2 - d;
                    }
                    if (i == 0) {
                        this.key3DRotAng[this.cObjetId] = d;
                        this.key3DRotAxe[this.cObjetId] = new Point3D(d6, d8, d7);
                    }
                    axis3D.rotate(d, -d6, -d8, -d7);
                    axis3D.getRotationXZY(point3D);
                    Point3D point3D5 = new Point3D();
                    point3D5.copy(point3D);
                    this.animators[this.cObjetId].addKeyRotation(n50 * 30, point3D5, new Point3D(-d6, -d8, -d7), d);
                    n3 += 12;
                }
                break;
            }
            case 45090: {
                int n52;
                int n53;
                int n54 = this.getShort();
                n3 += 2;
                for (n53 = 0; n53 < 8; ++n53) {
                    n52 = this.getByte();
                    ++n3;
                }
                n53 = (int)this.getUInt();
                n3 += 4;
                for (n52 = 0; n52 < n53; ++n52) {
                    int n55 = (int)this.getUInt();
                    n3 += 4;
                    int n56 = this.getShort();
                    n3 += 2;
                    double d = this.getFloat();
                    double d9 = this.getFloat();
                    double d10 = this.getFloat();
                    if (n52 == 0) {
                        this.key3DZoom[this.cObjetId] = new Point3D(d, d10, d9);
                    }
                    n3 += 12;
                }
                break;
            }
            case 45091: {
                int n57;
                int n58;
                int n59 = this.getShort();
                n3 += 2;
                for (n58 = 0; n58 < 8; ++n58) {
                    n57 = this.getByte();
                    ++n3;
                }
                n58 = (int)this.getUInt();
                n3 += 4;
                for (n57 = 0; n57 < n58; ++n57) {
                    int n60 = (int)this.getUInt();
                    n3 += 4;
                    int n61 = this.getShort();
                    n3 += 2;
                    float f = this.getFloat();
                    if (this.cObjet instanceof Camera3D) {
                        ((Camera3D)this.cObjet).setFOV(f);
                    }
                    n3 += 4;
                }
                break;
            }
            case 45075: {
                double d = this.getFloat();
                double d11 = this.getFloat();
                double d12 = this.getFloat();
                n3 += 12;
                this.cObjet.pivot.set(d, d12, d11);
                break;
            }
            case 45076: {
                double d = this.getFloat();
                double d13 = this.getFloat();
                double d14 = this.getFloat();
                n3 += 12;
                double d15 = this.getFloat();
                double d16 = this.getFloat();
                double d17 = this.getFloat();
                n3 += 12;
                this.cObjet.center.set((d + d15) * 0.5, (d14 + d17) * 0.5, (d13 + d16) * 0.5);
                break;
            }
            case 45056: {
                this.isKeyFrame = true;
                this.cObjetId = 0;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45064: {
                long l = this.getUInt();
                long l2 = this.getUInt();
                n3 += 8;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45065: {
                long l = this.getUInt();
                n3 += 4;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45066: {
                this.keyFrameRevision = this.getShort();
                this.keyFrameFileName = this.getString();
                this.KeyFrameNbFrame = this.getUInt();
                n3 += 2;
                n3 += this.keyFrameFileName.length() + 1;
                n3 += 4;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 19789: {
                this.cObjetId = 0;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 15677: {
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45058: {
                ++this.cObjetId;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45059: {
                ++this.cObjetId;
                while (n3 < n5) {
                    n3 += this.decodeChunk(n + 1);
                }
                break;
            }
            case 45060: {
                ++this.cObjetId;
                break;
            }
        }
        this.setProgress(50 + 50 * this.nbBytesDecoded / this.inputSize);
        this.skip(n4, n3, n5 - n3);
        this.popChunk();
        return n5;
    }

    private int readByteColor() {
        int n = this.getUByte();
        int n2 = this.getUByte();
        int n3 = this.getUByte();
        return n << 16 | n2 << 8 | n3;
    }

    private int readFloatColor() {
        int n = (int)(this.getFloat() * 255.0f);
        int n2 = (int)(this.getFloat() * 255.0f);
        int n3 = (int)(this.getFloat() * 255.0f);
        return n << 16 | n2 << 8 | n3;
    }

    private int readIntPercent() {
        return this.getUShort();
    }

    private int readFloatPercent() {
        return (int)this.getFloat();
    }

    private Material getTempMateriauByName(String string) {
        for (int i = 0; i < this.tMateriaux3D.length; ++i) {
            if (this.tMateriaux3D[i] == null || !this.tMateriaux3D[i].nom.equals(string)) continue;
            return this.tMateriaux3D[i];
        }
        return null;
    }

    private Scene3DObject getTempObjetByName(String string) {
        for (int i = 0; i < this.tObjets3D.length; ++i) {
            if (this.tObjets3D[i] == null || this.tObjets3D[i].nom == null || !this.tObjets3D[i].nom.equals(string)) continue;
            return this.tObjets3D[i];
        }
        return null;
    }

    private Scene3DObject getTempObjetById(int n) {
        for (int i = this.tObjets3D.length - 1; i >= 0; --i) {
            if (this.tObjets3D[i] == null || this.tObjets3D[i].id != n) continue;
            return this.tObjets3D[i];
        }
        return null;
    }

    private int getByte() {
        ++this.nbBytesDecoded;
        return this.input.read();
    }

    private int getUByte() {
        int n = this.getByte();
        if (n < 0) {
            n = -n;
        }
        return n;
    }

    private int getInt() {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    private long getUInt() {
        long l = this.getUByte();
        long l2 = this.getUByte();
        long l3 = this.getUByte();
        long l4 = this.getUByte();
        return l4 << 24 | l3 << 16 | l2 << 8 | l;
    }

    private int getShort() {
        int n = this.getByte();
        int n2 = this.getByte();
        return n2 << 8 | n;
    }

    private int getUShort() {
        int n = this.getUByte();
        int n2 = this.getUByte();
        return n2 << 8 | n;
    }

    private float getFloat() {
        int n = this.getByte();
        int n2 = this.getByte();
        int n3 = this.getByte();
        int n4 = this.getByte();
        return Float.intBitsToFloat(n4 << 24 | n3 << 16 | n2 << 8 | n);
    }

    private String getString() {
        String string = new String();
        int n = this.getByte();
        while (n != 0) {
            string = string + (char)n;
            n = this.getByte();
        }
        return string;
    }

    private void skip(int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        this.nbBytesDecoded += n3;
        for (int i = 0; i < n3; ++i) {
            int n4 = this.getByte();
        }
    }
}

