/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.test;

import net.dzzd.DzzD;
import net.dzzd.DzzDApplet;
import net.dzzd.access.IMappingUV;
import net.dzzd.access.IMaterial;
import net.dzzd.access.IMesh3D;
import net.dzzd.access.IRender3D;
import net.dzzd.access.IScene3D;
import net.dzzd.access.IScene3DLoader;
import net.dzzd.access.IURLTexture;
import net.dzzd.access.IVertex3D;
import net.dzzd.test.Grid3D;
import net.dzzd.utils.Log;
import net.dzzd.utils.MathX;

public class Sea
extends DzzDApplet
implements Runnable {
    public static final long serialVersionUID = 1L;
    private IRender3D render;
    private IScene3D scene;
    private boolean run = false;
    private Grid3D grid;
    private IMappingUV mappingUV;
    long start = System.currentTimeMillis();
    int t = 0;
    int nb = 0;

    public void start() {
        this.scene = DzzD.newScene3D();
        this.render = DzzD.newRender3D("SOFT", null);
        this.setLayout(null);
        this.add(this.render.getCanvas());
        this.render.setSize(this.getSize().width, this.getSize().height, 1);
        this.scene.getCurrentCamera3D().setZoomY((double)this.render.getWidth() / (double)this.render.getHeight());
        this.scene.getCurrentCamera3D().setFOV(70.0);
        this.render.setCamera3D(this.scene.getCurrentCamera3D());
        this.scene.getLight3DById(0).getRotation().setX(-1.2566370614359172);
        this.scene.setBackgroundColor(85);
        Thread thread = new Thread(this);
        this.run = true;
        thread.start();
    }

    public void destroy() {
        this.run = false;
    }

    private void createScene3D() {
        IScene3DLoader iScene3DLoader = DzzD.newScene3DLoader();
        iScene3DLoader.loadScene3D(this.getBaseURL() + "./", "SKY.3DS");
        this.scene.setScene3DLoader(iScene3DLoader);
        do {
            this.scene.updateMonitoredSceneObjects();
            DzzD.sleep(200L);
            Thread.yield();
        } while (this.scene.getNbMonitoredSceneObject() != 0);
        IMesh3D iMesh3D = this.scene.getMesh3DByName("SKY");
        if (iMesh3D != null) {
            iMesh3D.zoom(10000.0, 10000.0, 10000.0);
            iMesh3D.getRender3DMode().disableRender3DMode(1);
            iMesh3D.setSolid(false);
        }
        IMaterial iMaterial = DzzD.newMaterial();
        iMaterial.setName("SeaMaterial");
        iMaterial.setDiffuseColor(0xFFFFFF);
        iMaterial.setSpecularColor(85);
        iMaterial.setSpecularPower(45);
        iMaterial.setSpecularLevel(100);
        iMaterial.setSelfIlluminationLevel(0);
        IURLTexture iURLTexture = DzzD.newURLTexture();
        iURLTexture.setBaseURL(this.getCodeBase().toString() + "./");
        iURLTexture.setSourceFile("WATER.JPG");
        iMaterial.setDiffuseTexture(iURLTexture);
        this.mappingUV = DzzD.newMappingUV();
        this.mappingUV.setVZoom(0.2f);
        this.mappingUV.setUZoom(0.2f);
        this.mappingUV.setUOffset(3.5f);
        this.mappingUV.setVOffset(3.5f);
        iMaterial.setMappingUV(this.mappingUV);
        this.scene.addMaterial(iMaterial);
        this.scene.addTexture(iURLTexture);
        this.grid = new Grid3D(36, 25, iMaterial);
        IMesh3D iMesh3D2 = this.grid.getMesh3D();
        iMesh3D2.getPosition().set(0.0, 0.0, 0.0);
        iMesh3D2.getPivot().set(18.0, 0.0, 0.0);
        iMesh3D2.setOctreeEnabled(false);
        iMesh3D2.setName("Sea");
        this.scene.addMesh3D(iMesh3D2);
    }

    private void updateWorld() {
        int n;
        double d = this.seaHeight(0.0, 0.0);
        this.scene.getCurrentCamera3D().getRotation().setX((-0.05 - d * 0.1) * Math.PI);
        this.scene.getCurrentCamera3D().getPosition().setY(d + 1.5);
        IMesh3D iMesh3D = this.scene.getMesh3DByName("SKY");
        if (iMesh3D != null) {
            iMesh3D.getRotation().set(0.0, 0.0, 0.0);
            iMesh3D.getPosition().copy(this.scene.getCurrentCamera3D().getPosition());
        }
        IVertex3D[] iVertex3DArray = this.grid.getMesh3D().getVertex3D();
        for (n = 0; n < iVertex3DArray.length; ++n) {
            IVertex3D iVertex3D = iVertex3DArray[n];
            iVertex3D.setY(this.seaHeight(iVertex3D.getX(), iVertex3D.getZ()));
        }
        this.t = (int)(System.currentTimeMillis() - this.start) >> 2;
        this.grid.getMesh3D().buildSphereBoxAndCenter();
        this.grid.getMesh3D().buildFacesNormals();
        this.mappingUV.setUOffset(3.5f + (float)this.t * 1.0E-4f);
        this.mappingUV.setVOffset(3.5f + (float)this.t * 1.0E-4f);
        ++this.nb;
        if (this.nb % 100 == 0) {
            n = (int)((long)(1000 * this.nb) / (System.currentTimeMillis() - this.start));
            Log.log("fps" + n);
        }
    }

    private double seaHeight(double d, double d2) {
        double d3 = 0.0;
        d3 += 0.2 * MathX.cos((double)this.t * 0.01 + (d + d2) * 1.0);
        d3 += 0.15 * MathX.cos((double)this.t * 0.005 + d * 0.5);
        return d3 *= 1.3;
    }

    public void run() {
        this.createScene3D();
        while (this.run) {
            this.updateWorld();
            this.renderSingleFrame();
            Thread.yield();
        }
    }

    public void renderSingleFrame() {
        this.scene.setScene3DObjectToWorld();
        this.scene.setScene3DObjectToCamera();
        this.render.renderScene3D(this.scene);
    }
}

