/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.extension.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.glu.GLU;
import net.dzzd.extension.jogl.JOGLShader;

public class JOGLShaderProgram {
    private int programId = -1;
    private GL gl;
    private GLU glu = new GLU();
    private JOGLShader vertexShader = null;
    private JOGLShader fragmentShader = null;
    private boolean compiled = false;

    public JOGLShaderProgram(GL gL) {
        this.gl = gL;
    }

    public void setVertexShader(JOGLShader jOGLShader) {
        this.vertexShader = jOGLShader;
    }

    public void setFragmentShader(JOGLShader jOGLShader) {
        this.fragmentShader = jOGLShader;
    }

    private boolean compile() {
        if (this.vertexShader != null) {
            this.vertexShader.compile();
        }
        if (this.fragmentShader != null) {
            this.fragmentShader.compile();
        }
        if (this.vertexShader != null) {
            System.out.println("vertexShader id = " + this.vertexShader.getId());
        }
        if (this.fragmentShader != null) {
            System.out.println("vertexShader id = " + this.fragmentShader.getId());
        }
        this.programId = this.gl.glCreateProgramObjectARB();
        if (this.vertexShader != null) {
            this.gl.glAttachObjectARB(this.programId, this.vertexShader.getId());
        }
        if (this.fragmentShader != null) {
            this.gl.glAttachObjectARB(this.programId, this.fragmentShader.getId());
        }
        this.gl.glLinkProgramARB(this.programId);
        String string = this.getGLError(this.gl);
        if (string != null) {
            System.out.println("Shader linkage error :\n" + string);
        }
        this.compiled = true;
        return true;
    }

    public void setEnable(boolean bl) {
        if (!this.compiled) {
            this.compile();
        }
        if (bl) {
            this.gl.glUseProgramObjectARB(this.programId);
            return;
        }
        this.gl.glUseProgramObjectARB(0);
    }

    private String getGLError(GL gL) {
        boolean bl = false;
        String string = "";
        int n = gL.glGetError();
        while (n != 0) {
            string = string + (bl ? "\n" : "") + this.glu.gluErrorString(n);
            bl = true;
            n = gL.glGetError();
        }
        return bl ? string : null;
    }
}

