/*
 * Decompiled with CFR 0.152.
 */
package net.dzzd.extension.loader;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.dzzd.access.IProgressListener;
import net.dzzd.extension.loader.IExtension;
import net.dzzd.extension.loader.IExtensionLoader;
import net.dzzd.utils.Log;

public class ExtensionLoader
extends ClassLoader
implements IExtensionLoader {
    private static ExtensionLoader loader = null;
    private Hashtable classPool;
    private String extDir;

    public ExtensionLoader(Class clazz) throws Exception {
        super(clazz.getClassLoader());
        Thread.currentThread().setContextClassLoader(this);
        System.setSecurityManager(new MySecurityManager());
        this.classPool = new Hashtable();
        this.extDir = System.getProperty("user.home");
    }

    public static IExtensionLoader getLoader(final Class clazz) throws Exception {
        if (loader != null) {
            return loader;
        }
        loader = null;
        return (ExtensionLoader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                loader = new ExtensionLoader(clazz);
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    try {
                        securityManager.checkWrite("ExtensionLoader");
                        securityManager.checkPropertiesAccess();
                    }
                    catch (SecurityException securityException) {
                        throw new Exception("User rejected certificate");
                    }
                }
                return loader;
            }
        });
    }

    protected void addClass(String string, byte[] byArray) throws Exception {
        if (this.classPool.containsKey(string)) {
            throw new Exception("ExtensionLoader: Cannot add class " + string + ", already in classpool");
        }
        String string2 = string.replace(File.separator.charAt(0), '.');
        string2 = string.replace('\\', '.');
        string2 = string.replace('/', '.');
        this.classPool.put(string2, byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long readTimeStamp(File file) {
        long l;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = bufferedReader.readLine();
            l = Long.parseLong(string);
        }
        catch (Throwable throwable) {
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                return -1L;
            }
        }
        bufferedReader.close();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTimeStamp(File file, long l) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            try {
                bufferedWriter.write("" + l + "\n");
                bufferedWriter.flush();
            }
            finally {
                bufferedWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void downloadJar(URL uRL, File file, IProgressListener iProgressListener) {
        FilterOutputStream filterOutputStream = null;
        InputStream inputStream = null;
        URLConnection uRLConnection = null;
        try {
            Log.log((String)uRL.toString());
            uRLConnection = uRL.openConnection();
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            inputStream = uRLConnection.getInputStream();
            int n = inputStream.available();
            Log.log((String)("downloading jar with size: " + uRLConnection.getContentLength()));
            if (n < 1) {
                n = 1024;
            }
            byte[] byArray = new byte[n];
            while ((n = inputStream.read(byArray)) > 0) {
                ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
            }
            filterOutputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (filterOutputStream != null) {
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected void addJar(File file) throws Exception {
        ZipFile zipFile = new ZipFile(file);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class")) continue;
            Log.log((String)("addjar: found class in jarfile: " + zipEntry.getName()));
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = inputStream.available();
            if (n < 1) {
                n = 1024;
            }
            byte[] byArray = new byte[n];
            int n2 = 0;
            while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            inputStream.close();
            byteArrayOutputStream.flush();
            this.addClass(zipEntry.getName(), byteArrayOutputStream.toByteArray());
            byteArrayOutputStream.reset();
        }
    }

    public void loadJar(String string, String string2, String string3, IProgressListener iProgressListener) throws Exception {
        iProgressListener.setName(string3);
        iProgressListener.setProgress(0);
        iProgressListener.setFinished(false);
        iProgressListener.setStarted(true);
        String string4 = this.extDir + File.separator + string;
        Log.log((String)("extension installation directory: " + string4));
        File file = new File(string4);
        if (!file.exists() && !file.mkdirs()) {
            throw new Exception("ExtensionLoader.loadJar: Cannot create install directory: " + string4);
        }
        URL uRL = new URL(string2 + string3);
        Log.log((String)(string2 + string3));
        File file2 = new File(string4, string3);
        File file3 = null;
        long l = uRL.openConnection().getLastModified();
        String string5 = "";
        int n = string3.lastIndexOf(".");
        string5 = n > 0 ? string3.substring(0, n) : string3;
        string5 = string5 + ".idx";
        Log.log((String)("index filename: " + string5));
        boolean bl = true;
        Log.log((String)file2.getAbsolutePath());
        if (file2.exists()) {
            Log.log((String)("extensionfile already exists: " + string3));
            file3 = new File(file, string5);
            if (file3.exists()) {
                Log.log((String)"indexfile already exists");
                long l2 = this.readTimeStamp(file3);
                bl = l2 != l;
                Log.log((String)("cached file dirty: " + bl + ", url timestamp: " + l + " cache stamp: " + l2));
            } else {
                Log.log((String)"indexfile doesn't exist, assume cache is dirty");
            }
        }
        if (bl) {
            if (file2.exists()) {
                if (file3 != null && file3.exists()) {
                    Log.log((String)"deleting old index file");
                    file3.delete();
                }
                file3 = new File(string4, string5);
                Log.log((String)"deleting old cached file");
                file2.delete();
            }
            this.downloadJar(uRL, file2, iProgressListener);
            file3 = new File(file, string5);
            Log.log((String)"writing timestamp to index file");
            this.writeTimeStamp(file3, l);
        }
        this.addJar(file2);
    }

    protected Class findClass(String string) {
        String string2 = string.concat(".class");
        if (this.classPool.containsKey(string2)) {
            byte[] byArray = (byte[])this.classPool.get(string2);
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        return null;
    }

    public Object loadExtension(String string, String string2, String string3, String string4, IProgressListener iProgressListener, String string5) {
        iProgressListener.setProgress(0);
        iProgressListener.setFinished(false);
        iProgressListener.setError(false);
        try {
            loader.loadJar(string4, string, string2, iProgressListener);
            Class<?> clazz = loader.loadClass(string3);
            if (clazz == null) {
                Log.log((String)"cannot find extension class : extensionClass");
            }
            IExtension iExtension = (IExtension)clazz.newInstance();
            iExtension.load(string, string4, iProgressListener, loader);
            Object obj = loader.loadClass(string5).newInstance();
            return obj;
        }
        catch (Exception exception) {
            iProgressListener.setProgress(100);
            iProgressListener.setFinished(true);
            iProgressListener.setError(true);
            exception.printStackTrace();
            return null;
        }
    }

    private class MySecurityManager
    extends SecurityManager {
        public void checkPermission(Permission permission) throws SecurityException, NullPointerException {
        }

        public void checkPermission(Permission permission, Object object) throws SecurityException, NullPointerException {
        }
    }
}

