/** 
 * 	Racer3D
 *
 * 	Simple car game using 3DzzD Web 3D Engine
 * 
 *  @author Bruno Augier 
 *  @version 2.0 - 01/04/2009
 *  @seealso http://dzzd.net/
 */


import net.dzzd.utils.Log;
 
import net.dzzd.access.*;
import net.dzzd.DzzDApplet;
import net.dzzd.*;
import net.dzzd.utils.io.*;

import java.awt.event.KeyEvent;
import java.awt.event.*;

import java.awt.*;
import java.net.*;
import java.awt.image.*;
import java.applet.*;


import java.util.*;

public final class RoadJOGL extends DzzDApplet
{	

	public final static long serialVersionUID=0x01;
	
	private int nbStart=0;
	MainGame mainGame;
	
	
	public void init()
	{
		//Tell the API where to locate extension (used for JOGL)
		DzzD.extensionBaseURL=this.getBaseURL()+"LIB/";	
		this.loadGame();
	}
	
	public void start()
	{
		System.out.println("Start : "+Thread.currentThread());
		if(this.nbStart++==0)			
			this.startGame();
	}
		

		
	public void destroy()
	{
		System.out.println("Destroy : "+Thread.currentThread());
		if(this.mainGame!=null)
			this.mainGame.stop();
		this.mainGame=null;
	}
	
	
	public void loadGame()
	{    	    	
    	/*
    	 *Create a Scene3DLoader to load our 3DS file
    	 * and start loading the 3D scene
    	 */
		IScene3DLoader s1=DzzD.newScene3DLoader();		
		s1.loadScene3D(this.getBaseURL()+"ROAD/","ROAD.3DS");
		IScene3DLoader s2=DzzD.newScene3DLoader();		
		s2.loadScene3D(this.getBaseURL()+"ROAD/","CAR.3DS");
		IScene3DLoader s3=DzzD.newScene3DLoader();		
		s3.loadScene3D(this.getBaseURL()+"ROAD/","SKY.3DS");
		
		
		
		//System.out.println(this.getBaseURL()+"ROAD/"+"ROAD.3DS");
		
		int nbScene3D=0;
		
		/**
		 * Attach the 3D loader to the Scene3D to monitor loading progress.
		 *  this way the scene3D will automatically load materials textures.
		 *   and add objects once loaded
		 */	
		 	
		IScene3D s=DzzD.newScene3D();
		s.setScene3DLoader(s1);	
		s.setScene3DLoader(s2);
		s.setScene3DLoader(s3);
		
		/** 
		 * Wait until all streaming object are loaded
		 * In this case we load a 3ds file so we will have a 
		 *  IScene3DLoader as monitored object.
		 * Then once it will be loaded we will have the textures it contain 
		 *  as a cupple of ITexture monitored objects
		 */
		//System.out.print("loading ");
		do
		{
			//System.out.print(".");
			s.updateMonitoredSceneObjects();
			DzzD.sleep(200);
			Thread.yield();
			
		}
		while(s.getNbMonitoredSceneObject()!=0);
		
		/**
		 * Once Scene3D is loaded
		 *  create and initialise the 3D renderer
		 */
		IRender3D r=DzzD.newRender3D("JOGL",null);

			
		IPoint3D lRot=s.getLight3DById(0).getRotation();
		lRot.set(-0.8,0.5,0.00);
		
		r.setSize(this.getWidth(),this.getHeight(),1);
		s.setCurrentCamera3DByName("Camera01");
		ICamera3D c=s.getCurrentCamera3D();
		c.setZoomY(((double)r.getWidth())/((double)r.getHeight()));
	//	c.setZMax(7500);
		c.setFOV(70);
	
		IMesh3D sky=s.getMesh3DByName("SKY.3DS");
		if(sky!=null)
		{
			sky.zoom(100000,100000,100000);
			sky.getRender3DMode().disableRender3DMode(DzzD.RM_LIGHT|DzzD.RM_TEXTURE_MIPMAP);
			sky.setSolid(false);
		
		}		
		
		r.setCamera3D(s.getCurrentCamera3D());
		
		this.mainGame=new MainGame(s,r,this);	
			
		r.getCanvas().setLocation(0,0);
		this.add(r.getCanvas());		
		
		
	}
	
	public void startGame()
	{
		this.mainGame.start();	
	}
	
	public void paint(Graphics g)
	{
		
	}
	
	public void update(Graphics g)
	{
	
		
	}
}
